﻿using System.Collections.Generic;

namespace Siger.ApiTPM.Result
{
    public class FaultFrequencyAnalysisResult : TpmResultBase
    {
        public IList<string> x { get; set; }

        public IList<double> y1 { get; set; }

        public IList<double> y2 { get; set; }

        public FaultFrequencyAnalysisResult()
        {
            x = new List<string>();
            y1 = new List<double>();
            y2 = new List<double>();
        }
    }

    public class FaultFrequency
    {
        public int machineCount { get; set; } = 0;

        public double radio { get; set; } = 0;
    }

    public class PlanTimeAnalysisResult : TpmResultBase
    {
        public List<PlanTimeCount> planTimeCounts { get; set; } = new List<PlanTimeCount>();

        public IList<string> x { get; set; }

        public IList<double> y1 { get; set; }

        public IList<double> y2 { get; set; }

        public PlanTimeAnalysisResult()
        {
            x = new List<string>();
            y1 = new List<double>();
            y2 = new List<double>();
        }
    }

    public class PlanTimeCount
    {
        public string name { get; set; }

        public double actualtime { get; set; }

        public double standardtime { get; set; }
    }
}
