﻿using System;
using System.ComponentModel;

namespace Siger.Middlelayer.Common.Helpers
{
    public class TranslateHelper
    {
        private readonly bool _translateStatus;
        public TranslateHelper(bool translateStatus)
        {
            _translateStatus = translateStatus;
        }

        public string GetTranslateText(Enum e)
        {
            if (_translateStatus)
            {
                return EnumHelper.GetEnumDesc((TranslateEnEnum)e);
            }

            return EnumHelper.GetEnumDesc((TranslateCnEnum)e);
        }
    }

    public enum TranslateEnEnum
    {
        #region TPM

        /// <summary>
        /// 天
        /// </summary>
        [Description("Days")]
        Days = 1,

        /// <summary>
        /// 周
        /// </summary>
        [Description("Week")]
        Week,

        /// <summary>
        /// 两周
        /// </summary>
        [Description("Two Weeks")]
        TwoWeeks,

        /// <summary>
        /// 月
        /// </summary>
        [Description("Mouth")]
        Mouth,

        /// <summary>
        /// 两月
        /// </summary>
        [Description("Two Mouths")]
        TwoMouths,

        /// <summary>
        /// 季度
        /// </summary>
        [Description("Quarter")]
        Quarter,

        /// <summary>
        /// 半年
        /// </summary>
        [Description("Half a year")]
        Halfayear,

        /// <summary>
        /// 年
        /// </summary>
        [Description("Year")]
        Year,

        /// <summary>
        /// 一直执行
        /// </summary>
        [Description("Always Operate")]
        Executeallthetime,

        /// <summary>
        /// 执行
        /// </summary>
        [Description("Operate")]
        Implementation,

        [Description("Yes")]
        Yes,

        [Description("No")]
        No,

        /// <summary>
        /// 维修员工
        /// </summary>
        [Description("Maintenance staff ")]
        MaintenanceStaff,

        /// <summary>
        /// 生产员工
        /// </summary>
        [Description("production staff ")]
        ProductionStaff,

        /// <summary>
        /// 报修，已生成工单
        /// </summary>
        [Description("called repair, work order had created ")]
        RepairReportWorkOrderGenerated,

        /// <summary>
        /// 其他
        /// </summary>
        [Description("Other")]
        Other,

        /// <summary>
        /// 维修反馈
        /// </summary>
        [Description("maintenance feedback")]
        MaintenanceFeedBack,

        /// <summary>
        /// 次
        /// </summary>
        [Description("Times")]
        Time,

        /// <summary>
        /// 待接单
        /// </summary>
        [Description("To be Taken")]
        TobeTaken,

        /// <summary>
        /// 待签到
        /// </summary>
        [Description("To be Signed In")]
        TobeSignedIn,

        /// <summary>
        /// 维修中
        /// </summary>
        [Description("Processing")]
        UnderRepair,

        /// <summary>
        /// 待复线
        /// </summary>
        [Description("To be Restored")]
        TobeRecovered,

        /// <summary>
        /// 待反馈
        /// </summary>
        [Description("To be Feed Back")]
        TobeFeedBack,

        /// <summary>
        /// 已完成
        /// </summary>
        [Description("Completed")]
        Completed,

        /// <summary>
        /// 正常
        /// </summary>
        [Description("Normal")]
        Normal,

        /// <summary>
        /// 库存报警
        /// </summary>
        [Description("Inventory alarm")]
        InventoryAlarm,

        /// <summary>
        /// 领用报警
        /// </summary>
        [Description("Picking alarm")]
        CollarAlarm,

        /// <summary>
        /// 入库
        /// </summary>
        [Description("Inbound")]
        Warehousing,

        /// <summary>
        /// 出库
        /// </summary>
        [Description("Outbound")]
        Outofwarehouse,

        /// <summary>
        /// 已提交维修反馈单，维修完成
        /// </summary>
        [Description("had submitted feedback, maintenance completed")]
        MaintenanceFeedbackSheetSubmittedMaintenanceCompleted,

        /// <summary>
        /// 已提交维修反馈单，请
        /// </summary>
        [Description("had submitted feedback, wait ")]
        MaintenanceFeedbackSheetSubmittedPlease,

        /// <summary>
        /// 确认完成
        /// </summary>
        [Description("to confirm.")]
        ConfirmCompeletion,

        /// <summary>
        /// 已编辑维修反馈单
        /// </summary>
        [Description("had edited maintenance feedback")]
        EditedMaintenanceFeedbackSheet,

        /// <summary>
        /// 已接单，正在赶往现场
        /// </summary>
        [Description("had taken Order,is rushing to the site")]
        OrderReceivedRushingToTheScene,

        /// <summary>
        /// 已接单
        /// </summary>
        [Description("had taken Order")]
        OrderReceived,

        /// <summary>
        /// 已签到
        /// </summary>
        [Description("Checked in")]
        CheckedIn,

        /// <summary>
        /// 已到达现场签到
        /// </summary>
        [Description("Attendance on site")]
        AttendanceOnSite,

        /// <summary>
        /// 已维修完成，请生产员工确认复线。
        /// </summary>
        [Description("Maintenance completed, wait for production staff to confirm restoration.")]
        MaintenanceCompletedPleaseConfirmProductionStaffRewire,

        /// <summary>
        /// 已完成维修,请确认复线
        /// </summary>
        [Description("Maintenance completed, please confirm restoration.")]
        MaintenanceCompletedPleaseConfirmMultiline,

        /// <summary>
        /// 已确认复线
        /// </summary>
        [Description("Restoration Confirmed.")]
        ConfirmedRestoreProductionLine,

        /// <summary>
        /// 拒绝复线，维修员工请继续维修
        /// </summary>
        [Description("Restoration Rejected, wait for maintenance staff re-repair.")]
        NoRewiringMaintenanceStaffPleaseContinueMaintenance,

        /// <summary>
        /// 拒绝复线,请继续维修
        /// </summary>
        [Description("Restoration Rejected, please re-repair.")]
        NoMultipleConnectionPleaseContinueMaintenance,

        /// <summary>
        /// 工单取消
        /// </summary>
        [Description("Work order cancelled")]
        WorkOrderCancelled,

        /// <summary>
        /// 工单已取消
        /// </summary>
        [Description("Work order cancelled")]
        WorkOrderBeCancelled,

        /// <summary>
        /// 已取消该维修工单，维修工单关闭
        /// </summary>
        [Description("Maintenance order had cancelled, maintenance order closed")]
        MaintenanceOrderCancelledMaintenanceOrderClosed,

        /// <summary>
        /// 合作维修
        /// </summary>
        [Description("Cooperative maintenance")]
        CooperativeMaintenance,

        /// <summary>
        /// 已参与
        /// </summary>
        [Description("Participated")]
        Participated,

        /// <summary>
        /// 异常上报
        /// </summary>
        [Description("Abnormal report")]
        AbnormalReport,

        /// <summary>
        /// 分钟未有响应,已向上反馈
        /// </summary>
        [Description(" mins no response, had reported to ")]
        NoResponseMinuteFeedbackUp,

        /// <summary>
        /// 已进入本工单
        /// </summary>
        [Description(" had involved.")]
        EnteredWorkOrder,//Entered this work order"

        /// <summary>
        /// 请注意，有维护保养项目未按期执行！
        /// </summary>
        [Description("Warning! Some maintenance projects are not operated as scheduled!")]
        NoteSomeMaintenanceProjectsNotImplementedScheduled,

        /// <summary>
        /// 计划维护
        /// </summary>
        [Description("Scheduled maintenance")]
        PlannedMaintenance,

        /// <summary>
        /// 今日
        /// </summary>
        [Description("Today")]
        Today,

        /// <summary>
        /// 台设备有计划维护任务
        /// </summary>
        [Description("Equipment are under scheduled maintenance task")]
        EquipmentPlannedMaintenanceTask,

        /// <summary>
        /// 一级备件类型
        /// </summary>
        [Description("First level spare parts")]
        TypeOfFirstClassSpareparts,

        /// <summary>
        /// 寻找技术支持
        /// </summary>
        [Description("Ask for tech assistant")]
        AskForTechAssistant,

        /// <summary>
        /// 维修内容不属于工作范畴
        /// </summary>
        [Description("Out of working scope")]
        OutOfWorkingScope,

        /// <summary>
        /// 换班
        /// </summary>
        [Description("Shift changing")]
        ShiftChanging,

        /// <summary>
        /// 已让步复线
        /// </summary>
        [Description("Temporarily Restored")]
        ConcessionRecovered,

        /// <summary>
        /// 已让步复线.生成事后维修工单
        /// </summary>
        [Description("temporarily restored. maint order created")]//Breakdown Maintenance
        ConcessionRecoveredGeneratingWorkOrder,

        /// <summary>
        /// 计划维护执行预警
        /// </summary>
        [Description("Scheduled Maint Alert")]
        Planmaintenanceearlywarning,

        /// <summary>
        /// 计划维护执行异常
        /// </summary>
        [Description("Scheduled Maint Abnormal")]
        Planmaintenanceexecutionabnormal,

        /// <summary>
        /// 距离计划维护任务结束还有：
        /// </summary>
        [Description("The Scheduled Task will end in ")]
        ScheduledTaskwillend,

        #endregion

        #region ACC

        /// <summary>
        /// 已经存在
        /// </summary>
        [Description("Existing")]
        Existing,

        /// <summary>
        /// 所有物料
        /// </summary>
        [Description("All materials")]
        AllMaterials,

        #endregion

        #region CNC

        /// <summary>
        /// 一车间
        /// </summary>
        [Description("A workshop")]
        AWorkshop,

        /// <summary>
        /// 平均
        /// </summary>
        [Description("Average")]
        Average,

        /// <summary>
        /// 准时完成数
        /// </summary>
        [Description("Punctual completion quantity")]
        PunctualCompletionQuantity,

        /// <summary>
        /// 最终完成数
        /// </summary>
        [Description("Final completion quantity")]
        FinalCompletionQuantity,

        /// <summary>
        /// 没有数据
        /// </summary>
        [Description("No data")]
        NoData,

        #endregion

        #region Dashboard

        /// <summary>
        /// 效率分析日报
        /// </summary>
        [Description("Efficiency Analysis Daily")]
        EfficiencyAnalysisDaily,

        /// <summary>
        /// 统计设备数量
        /// </summary>
        [Description("Statistical equipment quantity")]
        StatisticalEquipmentQuantity,

        /// <summary>
        /// 统计时间
        /// </summary>
        [Description("Statistical time")]
        Statisticaltime,

        /// <summary>
        /// 一、产出情况分析
        /// </summary>
        [Description("1.Analysis of outputs")]
        AnalysisOfOutputs,

        /// <summary>
        /// 序号
        /// </summary>
        [Description("No.")]
        SN,

        /// <summary>
        /// 设备位置
        /// </summary>
        [Description("Machine Line No.")]
        MachineLineNo,

        /// <summary>
        /// 程序号
        /// </summary>
        [Description("Program No.")]
        ProgramNo,

        /// <summary>
        /// 产品名称
        /// </summary>
        [Description("Product Name")]
        ProductName,

        /// <summary>
        /// 工序名称
        /// </summary>
        [Description("Production Process")]
        ProductionProcess,

        /// <summary>
        /// 理论产出数量
        /// </summary>
        [Description("Target Output")]
        TargetOutput,

        /// <summary>
        /// 实际产出数量
        /// </summary>
        [Description("Actual Output")]
        ActualOutput,

        /// <summary>
        /// 总效率
        /// </summary>
        [Description("Total efficiency")]
        TotalEfficiency,

        /// <summary>
        /// 空闲损失
        /// </summary>
        [Description("Idle Loss")]
        IdleLoss,

        /// <summary>
        /// 调试损失
        /// </summary>
        [Description("Debugging loss")]
        DebuggingLoss,

        /// <summary>
        /// 故障损失
        /// </summary>
        [Description("Alarm loss")]
        AlarmLoss,

        /// <summary>
        /// 计划外停机损失
        /// </summary>
        [Description("Downtime loss")]
        LossOfUnplannedDowntime,

        /// <summary>
        /// 二、今日设备总体运行情况
        /// </summary>
        [Description("2.Overall operation of equipment today")]
        OverallOperationOfTodayEquipment,

        /// <summary>
        /// 三、设备报警Top5
        /// </summary>
        [Description("3.Device alarm Top5")]
        DeviceAlarmTop5,

        /// <summary>
        /// 暂无数据
        /// </summary>
        [Description("No data temporarily")]
        NoDataTemporarily,

        /// <summary>
        /// 近七天产出统计
        /// </summary>
        [Description("Nearly seven days of output statistics")]
        NearlySevenDaysOfOutputStatistics,

        /// <summary>
        /// 关机
        /// </summary>
        [Description("Power off")]
        PowerOff,

        /// <summary>
        /// 运行
        /// </summary>
        [Description("Running")]
        Running,

        /// <summary>
        /// 空闲
        /// </summary>
        [Description("Idle")]
        Idle,

        /// <summary>
        /// 手动调试
        /// </summary>
        [Description("Manual/debugging")]
        ManualDebugging,

        /// <summary>
        /// 报警
        /// </summary>
        [Description("Alarm")]
        Alarm,

        /// <summary>
        /// 运行总时长
        /// </summary>
        [Description("Total running time")]
        TotalRunningTime,

        /// <summary>
        /// 小时
        /// </summary>
        [Description(" h")]
        Hour,

        /// <summary>
        /// 平均每台设备运行
        /// </summary>
        [Description("Average running time of each equipment is")]
        Averagerunningtimeofeachequipmentis,

        /// <summary>
        /// 报警总时长
        /// </summary>
        [Description("Total alarm time")]
        TotalAlarmTime,

        /// <summary>
        /// 平均每台设备报警
        /// </summary>
        [Description("Average alarm time per device is")]
        Averagealarmtimeperdeviceis,

        /// <summary>
        /// 空闲总时长
        /// </summary>
        [Description("Total idle time")]
        Totalidletime,

        /// <summary>
        /// 平均每台设备空闲
        /// </summary>
        [Description("Average idle time per device is")]
        Averageidletimeperdeviceis,

        /// <summary>
        /// 调试总时长
        /// </summary>
        [Description("Tota debug time")]
        Totadebugtime,

        /// <summary>
        /// 平均每台设备调试
        /// </summary>
        [Description("Average debug time per device is")]
        Averagedebugtimeperdeviceis,

        /// <summary>
        /// 关机总时长
        /// </summary>
        [Description("Total shutdown time")]
        Totalshutdowntime,

        /// <summary>
        /// 平均每台设备关机
        /// </summary>
        [Description("Average shutdown time per device is")]
        Averageshutdowntimeperdeviceis,

        /// <summary>
        /// 当日运行最佳Top5
        /// </summary>
        [Description("Best running of the day Top5")]
        BestrunningofthedayTop5,

        /// <summary>
        /// 当日运行最差Top5
        /// </summary>
        [Description("The worst running of the day Top5")]
        TheworstrunningofthedayTop5,

        /// <summary>
        /// 近15天设备平均报警时长
        /// </summary>
        [Description("Average alarm time of equipment in the past 15 days")]
        Averagealarmtimeofequipmentinthepast15days,

        /// <summary>
        /// 当日报警时长TOP5
        /// </summary>
        [Description("The alarm time of the day Top5")]
        ThealarmtimeofthedayTop5,

        /// <summary>
        /// 当日报警次数TOP5
        /// </summary>
        [Description("Number of alarms on th eday TOP5")]
        NumberofalarmsonthedayTOP5,

        /// <summary>
        /// 生产管理日报
        /// </summary>
        [Description("Production Management Daily")]
        ProductionManagementDaily,

        /// <summary>
        /// 生产日报
        /// </summary>
        [Description("Production Daily")]
        ProductionDaily,

        /// <summary>
        /// 一、工单执行分析
        /// </summary>
        [Description("WorkOrder Execution Analysis")]
        WorkOrderExecutionAnalysis,

        /// <summary>
        /// 工单号
        /// </summary>
        [Description("Workorder number")]
        Workordernumber,

        /// <summary>
        /// 计划生产数量
        /// </summary>
        [Description("Planned production quantity")]
        Plannedproductionquantity,

        /// <summary>
        /// 实际完工数量
        /// </summary>
        [Description("Actualquantity Completed")]
        ActualquantityCompleted,

        /// <summary>
        /// 交货期
        /// </summary>
        [Description("Delivery Date")]
        DeliveryDate,

        /// <summary>
        /// 剩余天数
        /// </summary>
        [Description("Remaining Days")]
        RemainingDays,

        /// <summary>
        /// OK产量
        /// </summary>
        [Description("OK production")]
        OKproduction,

        /// <summary>
        /// NOK产量
        /// </summary>
        [Description("NOK production")]
        NOKproduction,

        /// <summary>
        /// 合格率
        /// </summary>
        [Description("Pass rate")]
        Passrate,

        /// <summary>
        /// 数量
        /// </summary>
        [Description("Quantity")]
        Quantity,

        /// <summary>
        /// 产出效率
        /// </summary>
        [Description("Output efficiency")]
        Outputefficiency,

        /// <summary>
        /// 综合OEE
        /// </summary>
        [Description("Comprehensive OEE")]
        ComprehensiveOEE,

        /// <summary>
        /// 近15天设备综合效率
        /// </summary>
        [Description("Comprehensive efficiency of equipment in the past 15 days")]
        Comprehensiveefficiencyofequipmentinthepast15days,

        /// <summary>
        /// 当前设备运行状态
        /// </summary>
        [Description("Current equipment operation status")]
        Currentequipmentoperationstatus,

        /// <summary>
        /// 今日产出分析
        /// </summary>
        [Description("output analysis Today")]
        Todayoutputanalysis,

        /// <summary>
        /// 计划工单数量
        /// </summary>
        [Description("Number of planned work orders")]
        Numberofplannedworkorders,

        /// <summary>
        /// 产量达成率
        /// </summary>
        [Description("Yield achieved")]
        Yieldachieved,

        /// <summary>
        /// 计划达成率
        /// </summary>
        [Description("Achievement rate")]
        Achievementrate,

        /// <summary>
        /// 质量合格率
        /// </summary>
        [Description("Quality pass rate")]
        Qualitypassrate,

        #endregion

        /// <summary>
        /// 备料中
        /// </summary>
        [Description("Sparepart Preparing")]
        SparepartPreparing,

        /// <summary>
        /// 正在备料
        /// </summary>
        [Description("The warehouse keeper has received the spare parts request and is preparing")]
        SparepartPrepare,
    }

    public enum TranslateCnEnum
    {
        #region TPM

        [Description("天")]
        Days = 1,

        [Description("周")]
        Week,

        [Description("两周")]
        TwoWeeks,

        [Description("月")]
        Mouth,

        [Description("两月")]
        TwoMouths,

        [Description("季度")]
        Quarter,

        [Description("半年")]
        Halfayear,

        [Description("年")]
        Year,

        [Description("一直执行")]
        Executeallthetime,

        [Description("执行")]
        Implementation,

        [Description("是")]
        Yes,

        [Description("否")]
        No,

        [Description("维修员工")]
        MaintenanceStaff,

        [Description("生产员工")]
        ProductionStaff,

        [Description("报修，已生成工单")]
        RepairReportWorkOrderGenerated,

        [Description("其他")]
        Other,

        [Description("维修反馈")]
        MaintenanceFeedBack,

        [Description("次")]
        Time,

        [Description("待接单")]
        TobeTaken,

        [Description("待签到")]
        TobeSignedIn,

        [Description("维修中")]
        UnderRepair,

        [Description("待复线")]
        TobeRecovered,

        [Description("待反馈")]
        TobeFeedBack,

        [Description("已完成")]
        Completed,

        [Description("正常")]
        Normal,

        [Description("库存报警")]
        InventoryAlarm,

        [Description("领用报警")]
        CollarAlarm,

        [Description("入库")]
        Warehousing,

        [Description("出库")]
        Outofwarehouse,

        [Description("已提交维修反馈单，维修完成")]
        MaintenanceFeedbackSheetSubmittedMaintenanceCompleted,

        [Description("已提交维修反馈单，请")]
        MaintenanceFeedbackSheetSubmittedPlease,

        [Description("确认完成")]
        ConfirmCompeletion,

        [Description("已编辑维修反馈单")]
        EditedMaintenanceFeedbackSheet,

        [Description("已接单，正在赶往现场")]
        OrderReceivedRushingToTheScene,

        [Description("已接单")]
        OrderReceived,

        [Description("已签到")]
        CheckedIn,

        [Description("已到达现场签到")]
        AttendanceOnSite,

        [Description("已维修完成，请生产员工确认复线。")]
        MaintenanceCompletedPleaseConfirmProductionStaffRewire,

        [Description("已完成维修,请确认复线")]
        MaintenanceCompletedPleaseConfirmMultiline,

        [Description("已确认复线")]
        ConfirmedRestoreProductionLine,

        [Description("拒绝复线，维修员工请继续维修")]
        NoRewiringMaintenanceStaffPleaseContinueMaintenance,

        [Description("拒绝复线,请继续维修")]
        NoMultipleConnectionPleaseContinueMaintenance,

        [Description("工单取消")]
        WorkOrderCancelled,

        [Description("工单已取消")]
        WorkOrderBeCancelled,

        [Description("已取消该维修工单，维修工单关闭")]
        MaintenanceOrderCancelledMaintenanceOrderClosed,

        [Description("合作维修")]
        CooperativeMaintenance,

        [Description("已参与")]
        Participated,

        [Description("异常上报")]
        AbnormalReport,

        [Description("分钟未有响应,已向上反馈")]
        NoResponseMinuteFeedbackUp,

        [Description("已进入本工单")]
        EnteredWorkOrder,

        [Description("请注意，有维护保养项目未按期执行！")]
        NoteSomeMaintenanceProjectsNotImplementedScheduled,

        [Description("计划维护")]
        PlannedMaintenance,

        [Description("今日")]
        Today,

        [Description("台设备有计划维护任务")]
        EquipmentPlannedMaintenanceTask,

        [Description("一级备件类型")]
        TypeOfFirstClassSpareparts,

        [Description("寻找技术支持")]
        AskForTechAssistant,

        [Description("维修内容不属于工作范畴")]
        OutOfWorkingScope,

        [Description("换班")]
        ShiftChanging,

        [Description("已让步复线")]
        ConcessionRecovered,

        [Description("已让步复线。生成事后维修工单")]
        ConcessionRecoveredGeneratingWorkOrder,

        [Description("计划维护执行预警")]
        Planmaintenanceearlywarning,

        [Description("计划维护执行异常")]
        Planmaintenanceexecutionabnormal,

        [Description("距离计划维护任务结束还有：")]
        ScheduledTaskwillend,

        #endregion

        #region ACC

        [Description("已经存在")]
        Existing,

        [Description("所有物料")]
        AllMaterials,

        #endregion

        #region CNC

        [Description("一车间")]
        AWorkshop,

        [Description("平均")]
        Average,

        [Description("准时完成数")]
        PunctualCompletionQuantity,

        [Description("最终完成数")]
        FinalCompletionQuantity,

        [Description("没有数据")]
        NoData,

        #endregion

        #region Dashboard

        [Description("效率分析日报")]
        EfficiencyAnalysisDaily,

        [Description("统计设备数量")]
        StatisticalEquipmentQuantity,

        [Description("统计时间")]
        Statisticaltime,

        [Description("一、产出情况分析")]
        AnalysisOfOutputs,

        [Description("序号")]
        SN,

        [Description("设备位置")]
        MachineLineNo,

        [Description("程序号")]
        ProgramNo,

        [Description("产品名称")]
        ProductName,

        [Description("工序名称")]
        ProductionProcess,

        [Description("理论产出数量")]
        TargetOutput,

        [Description("实际产出数量")]
        ActualOutput,

        [Description("总效率")]
        TotalEfficiency,

        [Description("空闲损失")]
        IdleLoss,

        [Description("调试损失")]
        DebuggingLoss,

        [Description("故障损失")]
        AlarmLoss,

        [Description("计划外停机损失")]
        LossOfUnplannedDowntime,

        [Description("二、今日设备总体运行情况")]
        OverallOperationOfTodayEquipment,

        [Description("三、设备报警 top5")]
        DeviceAlarmTop5,

        [Description("暂无数据")]
        NoDataTemporarily,

        [Description("近七天产出统计")]
        NearlySevenDaysOfOutputStatistics,

        [Description("关机")]
        PowerOff,

        [Description("运行")]
        Running,

        [Description("空闲")]
        Idle,

        [Description("手动调试")]
        ManualDebugging,

        [Description("报警")]
        Alarm,

        [Description("运行总时长")]
        TotalRunningTime,

        [Description("小时")]
        Hour,

        [Description("平均每台设备运行")]
        Averagerunningtimeofeachequipmentis,

        [Description("报警总时长")]
        TotalAlarmTime,

        [Description("平均每台设备报警")]
        Averagealarmtimeperdeviceis,

        [Description("空闲总时长")]
        Totalidletime,

        [Description("平均每台设备空闲")]
        Averageidletimeperdeviceis,

        [Description("调试总时长")]
        Totadebugtime,

        [Description("平均每台设备调试")]
        Averagedebugtimeperdeviceis,

        [Description("关机总时长")]
        Totalshutdowntime,

        [Description("平均每台设备关机")]
        Averageshutdowntimeperdeviceis,

        [Description("当日运行最佳Top5")]
        BestrunningofthedayTop5,

        [Description("当日运行最差Top5")]
        TheworstrunningofthedayTop5,

        [Description("近15天设备平均报警时长")]
        Averagealarmtimeofequipmentinthepast15days,

        [Description("当日报警时长TOP5")]
        ThealarmtimeofthedayTop5,

        [Description("当日报警次数TOP5")]
        NumberofalarmsonthedayTOP5,

        [Description("生产管理日报")]
        ProductionManagementDaily,

        [Description("生产日报")]
        ProductionDaily,

        [Description("一、工单执行分析")]
        WorkOrderExecutionAnalysis,

        [Description("工单号")]
        Workordernumber,

        [Description("计划生产数量")]
        Plannedproductionquantity,

        [Description("实际完工数量")]
        ActualquantityCompleted,

        [Description("交货期")]
        DeliveryDate,

        [Description("剩余天数")]
        RemainingDays,

        [Description("OK产量")]
        OKproduction,

        [Description("NOK产量")]
        NOKproduction,

        [Description("合格率")]
        Passrate,
        
        [Description("数量")]
        Quantity,

        [Description("产出效率")]
        Outputefficiency,

        [Description("综合OEE")]
        ComprehensiveOEE,

        [Description("近15天设备综合效率")]
        Comprehensiveefficiencyofequipmentinthepast15days,

        [Description("当前设备运行状态")]
        Currentequipmentoperationstatus,

        [Description("今日产出分析")]
        Todayoutputanalysis,

        [Description("计划工单数量")]
        Numberofplannedworkorders,

        [Description("产量达成率")]
        Yieldachieved,

        [Description("计划达成率")]
        Achievementrate,

        [Description("质量合格率")]
        Qualitypassrate,

        #endregion

        [Description("备料中")]
        SparepartPreparing,

        [Description("仓库管理员已经收到备件请求，正在备货")]
        SparepartPrepare,
    }

    #region TPM

    public enum OutStockCategory_EN
    {
        /// <summary>
        /// 采购提货出库
        /// </summary>
        [Description("Purchase outbound")]
        Procurement,

        /// <summary>
        /// 销售提货出库
        /// </summary>
        [Description("Sales outbound")]
        Sales,

        /// <summary>
        /// 应急维修领用出库
        /// </summary>
        [Description("Emergency maintenance outbound")]
        Emergency,

        /// <summary>
        /// 借贷出库
        /// </summary>
        [Description("Borrowing outbound")]
        Loan,

        /// <summary>
        /// 借入还出
        /// </summary>
        [Description("Borrow out")]
        Borrow,

        /// <summary>
        /// 对账出库
        /// </summary>
        [Description("Checkout")]
        Reconciliation,

        /// <summary>
        /// 计划维护领用出库
        /// </summary>
        [Description("Scheduled maintenance outbound")]
        PlanRepair,
    }

    public enum InStockCategory_EN
    {
        /// <summary>
        /// 采购入库
        /// </summary>
        [Description("Procurement warehousing")]
        Procurement,

        /// <summary>
        /// 生产入库
        /// </summary>
        [Description("Production Warehousing")]
        Sales,
        /// <summary>
        /// 领用退回入库
        /// </summary>
        [Description("Receiving and returning to storage")]
        Emergency,

        /// <summary>
        /// 借贷入库
        /// </summary>
        [Description("Borrowing and warehousing")]
        Loan,

        /// <summary>
        /// 借出还入
        /// </summary>
        [Description("Lend and return")]
        Borrow,

        /// <summary>
        /// 对账入库
        /// </summary>
        [Description("Reconciliation and warehousing")]
        Reconciliation,

        /// <summary>
        /// 返修入库
        /// </summary>
        [Description("Repair into storage")]
        PlanRepair,
    }

    public enum RepairListStatus_EN
    {
        [Description("To be Taken")]
        TobeTaken = 200032,

        [Description("To be Signed In")]
        TobeSignedIn = 200033,

        [Description("Processing")]
        UnderRepair = 200034,

        [Description("To be Restored")]
        TobeRecovered = 200035,

        [Description("To be Feed Back")]
        TobeFeedBack = 900704,

        [Description("Work order cancelled")]
        WorkOrderCancelled = 900718,

        [Description("Cooperative maintenance")]
        CooperativeMaintenance = 900721,

        [Description("Abnormal report")]
        AbnormalReport = 900731,

        [Description("maintenance feedback")]
        MaintenanceFeedBack = 901104,
    }

    public enum RepairListStatus
    {
        [Description("待接单")]
        TobeTaken = 200032,

        [Description("待签到")]
        TobeSignedIn = 200033,

        [Description("维修中")]
        UnderRepair = 200034,

        [Description("待复线")]
        TobeRecovered = 200035,

        [Description("待反馈")]
        TobeFeedBack = 900704,

        [Description("已让步复线")]
        ConcessionRecovered = 901109,

        [Description("工单取消")]
        WorkOrderCancelled = 900718,

        [Description("合作维修")]
        CooperativeMaintenance = 900721,

        [Description("异常上报")]
        AbnormalReport = 900731,

        [Description("维修反馈")]
        MaintenanceFeedBack = 901104,

        [Description("备料中")]
        SparepartPreparing = 5000003
    }

    #endregion

    #region ACC

    public enum CheckType_Status_En
    {
        /// <summary>
        /// 打钩
        /// </summary>
        [Description("Tick")]
        O = 1,

        /// <summary>
        /// 填值
        /// </summary>
        [Description("Fill in value")]
        V = 2
    }

    public enum Basket_Status_En
    {
        /// <summary>
        ///上料
        /// </summary>
        [Description("Loading material")]
        upload = 1,
        /// 报工
        /// </summary>
        [Description("Business report")]
        report = 2,
        /// <summary>
        /// 转框
        /// </summary>
        [Description("Rotating frame")]        
        Change = 3,
        /// <summary>
        /// 修改
        /// </summary>
        [Description("Modify")]
        Modify = 4,
        /// <summary>
        /// 检验
        /// </summary>
        [Description("Quality check")]
        QC = 5
    }

    public enum Type_Status_En
    {
        /// <summary>
        /// 工单
        /// </summary>
        [Description("Work order")]
        workCode = 1,
        /// <summary>
        /// 料框
        /// </summary>
        [Description("Material frame")]
        basket = 2,
        /// <summary>
        /// 模具
        /// </summary>
        [Description("moulds")]
        moulds = 3,
        /// <summary>
        /// 箱子
        /// </summary>
        [Description("box")]
        box = 4

    }

    #endregion
}
