﻿using System;
using System.Threading.Tasks;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Configuration;

namespace Siger.Middlelayer.Log
{
    public class Logger
    {
        private static LogEngine _logEngine;

        public static bool Debug { get; set; }

        public static void RegisterTxtLogEngine(Module module)
        {
            _logEngine = new TxtLogEngine(module);

            WriteLineInfo($"module: {module} has been activated.");
        }

        public static void RegisterLogEngine(Module module)
        {
            var logType = ConfigManager.GetValue("LogSetting", "Type", 1);
            if (logType == 1)
            {
                _logEngine = new TxtLogEngine(module);
            }
            else if (logType == 2)
            {
                _logEngine = new MongoLogEngine(module);
            }

            WriteLineInfo($"module: {module} has been activated.");
        }


        public static void WriteLineInfo(string msg)
        {
            _logEngine?.Write(LogLevel.Info, msg);
        }

        public static async Task WriteLineInfoAsync(string msg)
        {
            if (_logEngine != null)
            {
                await _logEngine.WriteAsync(LogLevel.Info, msg).ConfigureAwait(false);
            }
        }

        public static void WriteLineWarn(string msg)
        {
            _logEngine?.Write(LogLevel.Warn, msg);
        }

        public static async Task WriteLineWarnAsync(string msg)
        {
            if (_logEngine != null)
            {
               await _logEngine.WriteAsync(LogLevel.Warn, msg).ConfigureAwait(false);
            }
        }

        public static void WriteLineError(string msg)
        {
            _logEngine?.Write(LogLevel.Error, msg);
        }

        public static async Task WriteLineErrorAsync(string msg)
        {
            if (_logEngine != null)
            {
               await _logEngine.WriteAsync(LogLevel.Error, msg).ConfigureAwait(false);
            }
        }

        public static void WriteLineVerbose(string msg)
        {
#if DEBUG
            _logEngine?.Write(LogLevel.Verbose, msg);
#endif
        }

        public static async Task WriteLineVerboseAsync(string msg)
        {
#if DEBUG
            if (_logEngine != null)
            {
               await _logEngine?.WriteAsync(LogLevel.Verbose, msg);
            }
#endif
        }

        public static void WriteLineDebug(string msg)
        {
#if DEBUG
            _logEngine?.Write(LogLevel.Debug, msg);
#endif
        }

        public static async Task WriteLineDebugAsync(string msg)
        {
#if DEBUG
            if (_logEngine != null)
            {
                await _logEngine?.WriteAsync(LogLevel.Debug, msg);
            }
#endif
        }
    }
}
