﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
namespace Siger.Middlelayer.Common.ModuleEnum
{
    /// <summary>
    /// Cnc module, start from 4000000
    /// </summary>
    public enum CncEnum
    {
        //  启动模块--枚举
        [Description("CNC服务配置加载失败")] LoadCfgFail = 4000000,
        [Description("CNC服务注册Consul失败")] RegConsulFail,
        [Description("该产品和产线下已配置工序")] RouteHasExist,
        [Description("请至少添加一道工序")] RouteIsEmpty,
        [Description("工序不能重复")] RouteHasRepeat,
        [Description("该产品在该产线下尚未配置工序")] RoutesNotFound,
        [Description("该产品下仍有未配置标准节拍的设备")] MachineCycleTimeNotFound,
        [Description("生产计划未找到")] PlanNotFound,
        [Description("批次数必须大于0")] BatchMustGreaterZero,
        [Description("该生产计划已排产")] PlanHasExist,
        [Description("该生产计划不能终止")] PlanCannotStop,
        [Description("工令单不存在")] WorkOrderNotExist,
        [Description("时间格式不正确")] DateTimeFormatError,
        [Description("该状态下不能打印")] WorkOrderCannotPrint,
        [Description("此设备类型已设置异常时间")] TimeSettingHasExist,
        [Description("订单数量不能大于5000")] PlanQuanlityOverFlow,
        [Description("该工单未安排在该设备上生产")] PlanNotFoundOnMachine,
        [Description("设备编号不存在")] MachineIdNotExist,
        [Description("报工数量大于工令单数量")] MaxReportCount,
        [Description("报工前请先首检")] InspectionFirst,
        [Description("该数据已在审核，请勿重复操作！")] DataAlreadyExists,
        [Description("只有未报工数据，才可以作废！")] DataToVoid,
        [Description("只有未报工数据，才可以报工！")] DataToReport,
        [Description("只有已报工数据，才可以审核！")] DataToExamine,
        [Description("数据已完工或已终止，不可以派工！")] DataToDispatch,
        [Description("订单号不能为空")]OrderNumberNotNull,
        [Description("工单类型不能为空")] WorkOrderTypeNotNull,
        [Description("导入数据重复")] DataToSame,
        [Description("该生产计划已下发")] ProductionPlanIssued,
        [Description("没有要更新的数据")] PlanNoChangeData,
        [Description("该订单存在未审核的变更记录")] PlanHasUnApprovRecord,
        [Description("该设备已经签到")] MachineIsSignIn
    }

    /// <summary>
    /// 休息时间类型
    /// </summary>
    public enum ProductionTimeType
    {
        [Description("工作日")]
        WorkingDay = 1,

        [Description("节假日")]
        Holiday,

        [Description("周末")]
        Weekend
    }

    /// <summary>
    /// 计划变更，更改字段
    /// </summary>
    public enum PlanChange 
    {
        [Description("订单号")]
        OrderNumber=1,

        [Description("订单数量")]
        Quantity,

        [Description("工单数量")]
        InstallCount,

        [Description("交货期")]
        DeliveryTime

    }

    /// <summary>
    /// 审核状态
    /// </summary>
    public enum AuditState 
    {
        [Description("待审核")]
        WaitState=1,

        [Description("已审核")]
        Reviewed,

        [Description("审核未通过")]
        AuditFailed,
    }

    /// <summary>
    /// 生产计划类型
    /// </summary>
    public enum PlanSource
    {
        [Description("手动添加")]
        Manual = 1,

        [Description("Excel导入")]
        ExcelImport,

        [Description("ERP对接")]
        ErpInterface
    }

    /// <summary>
    /// 生产计划状态
    /// </summary>
    public enum PlanProcess
    {
        [Description("未排产")]
        UnPlan,

        [Description("已排产")]
        HasPlan,

        [Description("生产中")]
        Producing,

        [Description("已完工")]
        Finished,

        [Description("已终止")]
        Stop,
    }
    /// <summary>
    /// 计划生产管理订单类型
    /// </summary>
    public enum PlanOrderType 
    {
        [Description("成品")]
        HasProduct = 1,
        [Description("新品")]
        NewProduct,
        [Description("调试")]
        Debugging,
        [Description("返工")]
        Rework,
    }

    public enum PersonStation 
    {
        [Description("工位")]
        Station = 1,
        [Description("人员")]
        Person,
    }

    public enum PlanStopState 
    {
        [Description("待生产")]
        ToProduced=1,
        [Description("生产中")]
        Producing,
    }

    /// <summary>
    /// 计划内派工
    /// </summary>
    public enum PlanDispatch
    {
       
        [Description("未下发")]
        UnIssue=1,

        [Description("未排产")]
        UnPlan=2,

        [Description("已派工")]
        HasPlan,

        [Description("生产中")]
        Producing,

        [Description("已完工")]
        Finished,

        [Description("已终止")]
        Stop,
        [Description("逾期")]
        Overdue,
        [Description("调机中")]
        Debugging,
        [Description("暂停中")]
        Suspend,
    }
    /// <summary>
    /// 计划外派工
    /// </summary>
    public enum PlanOutDispatch
    {
        [Description("未报工")]
        UnReport = 1,
        [Description("已报工")]
        HasReport,
        [Description("审核以通过")]
        Reviewed,
        [Description("审核未通过")]
        UnReviewed,
        [Description("已作废")]
        Voided,
    }
    /// <summary>
    /// 休息时间类型
    /// </summary>
    public enum TimeType
    {
        [Description("星期一")]
        Monday = 1,

        [Description("星期二")]
        Tuesday,

        [Description("星期三")]
        Wednesday,

        [Description("星期四")]
        Thursday,

        [Description("星期五")]
        Friday,

        [Description("星期六")]
        Saturday,

        [Description("星期日")]
        Sunday,

        [Description("节假日")]
        Holiday
    }

    public enum OrderReportApprovalStatus
    {
        [Description("待审核")]
        WaitingForApproval=0,

        [Description("审核通过")]
        Pass=1,

        [Description("审核不通过")]
        Deny=2
    }
    /// <summary>
    /// wo type 票据追溯枚举
    /// </summary>
    public enum WoType
    {
        /// <summary>
        /// 首检
        /// </summary>
        [Description("报工")]
        Report = 0,
        /// <summary>
        /// 首检
        /// </summary>
        [Description("首检")]
        First = 1,
        /// <summary>
        /// 巡检
        /// </summary>
        [Description("巡检")]
        Round = 2,
        /// <summary>
        /// 完工检
        /// </summary>
        [Description("完工检")]
        Complate = 3,
        /// <summary>
        /// 全检
        /// </summary>
        [Description("全检")]
        Full = 4
    }
}
