﻿using System;
using System.Collections.Generic;
using System.Text;
using Siger.Middlelayer.Share.Models.Cnc;

namespace Siger.Middlelayer.Share.Models
{
    public class MachineCanvasParetoInfoResult
    {
        public string startTime { get; set; }

        public string endTime { get; set; }

        public double total_time_span { get; set; }

        public IList<Canvas> canvas { get; set; }

        public IList<Pareto> pareto { get; set; }

        public MachineCanvasParetoInfoResult()
        {
            canvas = new List<Canvas>();

            pareto = new List<Pareto>();
        }
    }

    public class Canvas
    {
        public int machineID { get; set; }

        public string machineTitle { get; set; }

        public string t_end_time { get; set; }

        public string t_start_time { get; set; }

        public double t_time_Span { get; set; }

        public IList<MachineStatusHold> list_msh { get; set; }

        public IList<ProgramYield> programNos { get; set; }

        public IList<SliceSummary> slicesummary { get; set; }

        public Canvas()
        {
            list_msh = new List<MachineStatusHold>();

            programNos = new List<ProgramYield>();

            slicesummary = new List<SliceSummary>();
        }
    }

    public class Pareto
    {
        public int machineID { get; set; }

        public string machineTitle { get; set; }

        public double total { get; set; }

        public IList<ShutdownHoldTime> listShutdownHoldTime { get; set; }

        public Pareto()
        {
            listShutdownHoldTime = new List<ShutdownHoldTime>();
        }
    }

    public class ShutdownHoldTime
    {
        public string factor { get; set; }

        public string factorName { get; set; }

        public double timeSpan { get; set; }
    }
}
