﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Utility.ExcelImport
{
    public class MachineEntity
    {
        public List<string> Levels { get; set; }

        [ExcelColumn("ID")]
        public string ID { get; set; }

        [ExcelColumn("设备分类(一级)")]
        public string ParentType { get; set; }

        [ExcelColumn("设备分类(二级)")]
        public string ChildType { get; set; }

        [ExcelColumn("设备名称")]
        public string Name { get; set; }

        [ExcelColumn("固定资产编号")]
        public string Code { get; set; }

        [ExcelColumn("生产厂商/品牌")]
        public string Factory { get; set; }

        [ExcelColumn("设备型号")]
        public string Model { get; set; }

        [ExcelColumn("入固日期")]
        public string MadeDate { get; set; }

        [ExcelColumn("出厂编号")]
        public string FactoryCode { get; set; }

        [ExcelColumn("1->NC设备2->非NC设备")]
        public string Category { get; set; }

        public MachineEntity()
        {
            Levels = new List<string>();
        }
    }

    public class MachineEntityList
    {
        public List<string> Levels { get; set; }

        [ExcelColumn("ID")]
        public string ID { get; set; }

        [ExcelColumn("设备分类(一级)")]
        public string ParentType { get; set; }

        [ExcelColumn("设备分类(二级)")]
        public string ChildType { get; set; }

        [ExcelColumn("设备名称")]
        public string Name { get; set; }

        [ExcelColumn("固定资产编号")]
        public string Code { get; set; }

        [ExcelColumn("生产厂商/品牌")]
        public string Factory { get; set; }

        [ExcelColumn("设备型号")]
        public string Model { get; set; }

        [ExcelColumn("入固日期")]
        public string MadeDate { get; set; }

        [ExcelColumn("出厂编号")]
        public string FactoryCode { get; set; }

        [ExcelColumn("1->NC设备2->非NC设备")]
        public string Category { get; set; }


        [ExcelColumn("MachineName")]
        public string machine_name { get; set; }

        [ExcelColumn("设备简称")]
        public string machine_shortname { get; set; }

        [ExcelColumn("负责人")]
        public string responsor { get; set; }

        [ExcelColumn("测试应用产品")]
        public string typical_application { get; set; }

        [ExcelColumn("尺寸-内径")]
        public string inside_diameter { get; set; }

        [ExcelColumn("尺寸-外径")]
        public string outside_diameter { get; set; }

        [ExcelColumn("径向载荷")]
        public string radial_load { get; set; }

        [ExcelColumn("轴向载荷")]
        public string axial_load { get; set; }

        [ExcelColumn("压力")]
        public string pressure { get; set; }

        [ExcelColumn("转速-数字")]
        public string speed { get; set; }

        [ExcelColumn("温度")]
        public string temperature { get; set; }

        [ExcelColumn("转速-文本")]
        public string rotation { get; set; }

        [ExcelColumn("样本润滑")]
        public string sample_lubrication { get; set; }

        [ExcelColumn("设备用油-润滑")]
        public string oil_lubrication { get; set; }

        [ExcelColumn("设备用油-液压")]
        public string oil_hydraulic { get; set; }

        [ExcelColumn("信号采集")]
        public string signal_monitor { get; set; }

        [ExcelColumn("测试工位")]
        public string position { get; set; }

        [ExcelColumn("设备尺寸")]
        public string machine_size { get; set; }

        public MachineEntityList()
        {
            Levels = new List<string>();
        }
    }
}
