﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class MachineStateEchartList : ImportBase
    {
        [ExcelColumn("日期/产线层级")]
        public string Abscissa { get; set; }

        [ExcelColumn("运行(%)")]
        public double Run { get; set; }

        [ExcelColumn("空闲(%)")]
        public double Idle { get; set; }

        [ExcelColumn("手动/调试(%)")]
        public double Debug { get; set; }

        [ExcelColumn("报警(%)")]
        public double Fault { get; set; }

        [ExcelColumn("关机(%)")]
        public double Shutdown { get; set; }
    }

    public class MachineStateList : ImportBase
    {
        [ExcelColumn("序号")]
        public int No { get; set; }

        [ExcelColumn("日期/产线层级")]
        public string Abscissa { get; set; }

        [ExcelColumn("运行(%)")]
        public double Run { get; set; }

        [ExcelColumn("运行(H)")]
        public double RunHour { get; set; }

        [ExcelColumn("空闲(%)")]
        public double Idle { get; set; }

        [ExcelColumn("空闲(H)")]
        public double IdleHour { get; set; }

        [ExcelColumn("手动/调试(%)")]
        public double Debug { get; set; }

        [ExcelColumn("手动/调试(H)")]
        public double DebugHour { get; set; }

        [ExcelColumn("报警(%)")]
        public double Fault { get; set; }

        [ExcelColumn("报警(H)")]
        public double FaultHour { get; set; }

        [ExcelColumn("关机(%)")]
        public double Shutdown { get; set; }

        [ExcelColumn("关机(H)")]
        public double ShutdownHour { get; set; }
    }
}
