﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class RoutingOutStationTemplate : ImportBase
    {
        [ExcelColumn("生产线")]
        public string line { get; set; }
        
        [ExcelColumn("工站")]
        public string station { get; set; }

        [ExcelColumn("结果")]
        public string eventno { get; set; }

        [ExcelColumn("状态")]
        public string status { get; set; }
    }

    public class RoutingOutStationList : RoutingOutStationTemplate
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int No { get; set; }
    }

    public class RoutingInStationTemplate : ImportBase
    {
        [ExcelColumn("生产线")]
        public string line { get; set; }

        [ExcelColumn("工站")]
        public string station { get; set; }

        [ExcelColumn("产品编号")]
        public string productid { get; set; }

        [ExcelColumn("状态")]
        public string status { get; set; }
    }

    public class RoutingInStationList : RoutingInStationTemplate
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int No { get; set; }
    }
}
