﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class SparepartTypeListForExport : ImportBase
    {
        [ExcelColumn("备件种类名称")]
        public string ChildType { get; set; }

        [ExcelColumn("上级备件类型")]
        public string ParentType { get; set; }

        [ExcelColumn("备件类型描述")]
        public string Description { get; set; }

        [ExcelColumn("包含备件种类数")]
        public string Num { get; set; }
    }

    public class SparepartTypeList : ImportBase
    {
        [ExcelColumn("一级类型")]
        [EmptyValidate("LevelOneTypeIsEmpty")]
        public string LevelOneType { get; set; }

        [ExcelColumn("二级类型")]
        public string LevelTwoType { get; set; }

        [ExcelColumn("三级类型")]
        public string LevelThreeType { get; set; }

        [ExcelColumn("四级类型")]
        public string LevelThourType { get; set; }

        [ExcelColumn("五级类型")]
        public string LevelFiveType { get; set; }
    }
}
