﻿using System;
using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class ToolChangeList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetCreate]
        public int No { get; set; }

        /// <summary>
        /// 设备编号
        /// </summary>
        [ExcelColumn("*设备编号")]
        [EmptyValidate("MachineCodeIsEmpty")]
        public string Code { get; set; }

        /// <summary>
        /// 设备名称
        /// </summary>
        [ExcelColumn("*设备名称")]
        public string Name { get; set; }

        /// <summary>
        /// 主轴名称
        /// </summary>
        [ExcelColumn("*主轴名称")]
        [EmptyValidate("SpindleNoIsEmpty")]
        public string SpindleNo { get; set; }

        /// <summary>
        /// 刀具名称
        /// </summary>
        [ExcelColumn("*刀具名称")]
        public string ToolName { get; set; }

        /// <summary>
        /// 刀具图纸号
        /// </summary>
        [ExcelColumn("*刀具图纸号")]
        public string ToolDrawingCode { get; set; }
        /// <summary>
        /// 刀具加工程序号
        /// </summary>
        [ExcelColumn("*刀具加工程序号")]
        [EmptyValidate("ToolProcesPn")]
        public string ToolProcesPn { get; set; }
        /// <summary>
        /// 刀位号
        /// </summary>
        [ExcelColumn("*刀位号")]
        [EmptyValidate("ToolLocationNameIsEmpty")]
        public string ToolNo { get; set; }

        /// <summary>
        /// 额定寿命
        /// </summary>
        [ExcelColumn("*额定寿命")]
        [EmptyValidate("RateLifeIsEmpty")]
        public int RateLife { get; set; }

        /// <summary>
        /// 剩余寿命
        /// </summary>
        [ExcelColumn("*剩余寿命")]
        public int RemainderLife { get; set; }

        /// <summary>
        /// 更换人员
        /// </summary>
        [ExcelColumn("*更换人员（工号）")]
        public string ChangeUser { get; set; }

        /// <summary>
        /// 更换时间
        /// </summary>
        [ExcelColumn("*更换时间")]
        [EmptyValidate("ChangeTimeIsEmpty")]
        public DateTime ChangeTime { get; set; }

        /// <summary>
        /// 更换原因
        /// </summary>
        [ExcelColumn("*更换原因")]
        [EmptyValidate("ChangeReasonIsEmpty")]
        public string ChangeReason { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        [ExcelColumn("备注")]
        public string Remark { get; set; }
    }
}
