﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class WOBookingItemTemplate : ImportBase
    {
        [ExcelColumn("生产线")]
        public string line { get; set; }

        [ExcelColumn("工站")]
        public string station  { get; set; }

        [ExcelColumn("项次")]
        [DonnetValidate]
        [DonnetCreate]
        public int seq { get; set; }

        [ExcelColumn("项目名称")]
        public string item { get; set; }

        [ExcelColumn("项目描述")]
        public string descr { get; set; }

        [ExcelColumn("维护人")]
        [DonnetValidate]
        [DonnetCreate]
        public string uid { get; set; }

        [ExcelColumn("维护时间")]
        [DonnetValidate]
        [DonnetCreate]
        public string transdatetime { get; set; }
    }

    public class WOBookingItemList : WOBookingItemTemplate
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int No { get; set; }
    }
}
