﻿using System.Collections.Generic;
using System.Linq;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal abstract class AccRepositoryBase<TEntity>: RepositoryBase<TEntity> where TEntity:AccEntityBase
    {
        private readonly ApiAccDbContext accDbContext;
        protected AccRepositoryBase(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public siger_project_user GetUserInfo(int id, int projectid)
        {
            return accDbContext.siger_project_user.FirstOrDefault(t => t.mid == id && t.status == (int)RowState.Valid);
        }
        protected IEnumerable<siger_project_level_section> GetSonLevelSections(int parentId, int projectid)
        {
            var query = from c in accDbContext.siger_project_level_section
                        where c.parentid == parentId && c.projectid == projectid && c.status == (int)RowState.Valid
                        select c;

            return query.ToList().Concat(query.ToList().SelectMany(t => GetSonLevelSections(t.id, projectid)));
        }
        
        public IEnumerable<int>GetSonLevelSectionIds(int sectionId,int projectId)
        {
            var list = new List<int>();
            var query = GetSonLevelSections(sectionId, projectId);
            list.Add(sectionId);
            foreach (var section in query.ToList())
            {
                list.Add(section.id);
            }
            return list;
        }

        public siger_project_level_section GetLevel_Section(int id,int projectId)
        {
            return accDbContext.siger_project_level_section.FirstOrDefault(t => t.id == id && t.projectid==projectId);
        }
        
        public int GetProjectLanguage(int projectId)
        {
            var project = accDbContext.siger_project.FirstOrDefault(t => t.id == projectId);
            return project?.language ?? 0;
        }

        public IPagedCollectionResult<ResponsePrinterSetting> GetPagedList(List<int> sectionid, int projectId, int page, int pagesize)
        {
            var query = from q in accDbContext.siger_tr_printer_setting
                        join p in accDbContext.siger_project_level_section on q.station equals p.id
                        join u in accDbContext.siger_project_user on q.uid.ToInt() equals u.mid
                        where sectionid.Contains(q.station) && q.projectId == projectId && q.status == (int)RowState.Valid
                        select new ResponsePrinterSetting
                        {
                            id = q.id,
                            printtype = q.printtype,
                            station = q.station,
                            port = q.port,
                            uid = q.uid,
                            uid_value=u.name,
                            printername = q.printername,
                            transdatetime = q.transdatetime.ToString(ParameterConstant.DateTimeFormat)
                        };
         
            var queryresult = query.GroupBy(p => p.id).Select(q => q.FirstOrDefault()).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();

            return new PagedCollectionResult<ResponsePrinterSetting>(queryresult, queryresult.Count());
        }
    }
}
