﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class InspectStandardOptionRepository : AccRepositoryBase<siger_qms_inspection_standard_option>, IInspectStandardOptionRepository
    {
        private ApiAccDbContext accDbContext;
        public InspectStandardOptionRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public IEnumerable<ResponseRoute> GetRoute(int id)
        {
            var result = new List<ResponseRoute>();
            var routes = accDbContext.siger_project_product_route.Where(q => q.id == id).FirstOrDefault();
            if (routes != null)
            {
                    var route = new ResponseRoute();
                    route.ID = routes.id;
                    route.name = routes.name;
                    result.Add(route);
            }
            return result;
        }

        public IEnumerable<ResponseRoute> GetRouteList(int productid, int projectid)
        {
            var result = new List<ResponseRoute>();
            var routes = accDbContext.siger_project_product_route.Where(q => q.productId == productid && q.projectId == projectid && q.status == (int)RowState.Valid).ToList();
            if (routes!=null)
            {
                foreach (var item in routes)
                {
                    var route = new ResponseRoute();
                    route.ID = item.id;
                    route.name = item.name;
                    result.Add(route);
                }
            }
            return result;
        }
    }
}
