﻿using System;
using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerPackingFullQtyRespository : AccRepositoryBase<SigerTrPackingFullQty>, ISigerPackingFullQty
    {
        private ApiAccDbContext accDbContext;
        public SigerPackingFullQtyRespository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public CommonImportResult ImportPackingFullQty(IEnumerable<PackingFullQtyTemplate> checkitems, int projectid, int userid)
        {
            var errors = new List<string>();
            var rowIndex = 1;
            foreach (var p in checkitems)
            {
                rowIndex++;
                var regions = accDbContext.siger_tr_dict.FirstOrDefault(t => t.status == (int)RowState.Valid
                   && t.cat == AccDictCost.region && t.dval == p.region && t.projectId == projectid);
                var productcheck = accDbContext.siger_project_product.FirstOrDefault(t => t.code == p.productid && t.status == (int)RowState.Valid && t.projectid == projectid);
                if (productcheck == null)
                {
                    errors.Add($"{rowIndex},{(int)RequestEnum.ProductidNotNull}");
                }

                if (regions == null)
                    errors.Add($"{rowIndex},{(int)RequestEnum.RegionNotExsitInDict}");
                else
                {
                    var model = accDbContext.siger_tr_packing_fullqty.FirstOrDefault(t => t.PN == p.pn && t.Region == regions.dval && t.ProductID == p.productid);
                    var repeats = checkitems.Where(t => t.pn == p.pn && t.region == p.region && t.productid == p.productid);
                    if (model != null|| repeats.Count() > 1)
                    {
                        errors.Add($"{rowIndex},{(int)RequestEnum.ProductNoPnRegionExsit}");
                    }                        
                }
                if (string.IsNullOrWhiteSpace(p.qty) || p.qty.ToInt() <= 0)
                {
                    errors.Add($"{rowIndex},{(int)RequestEnum.FullQtyMustMoreThanZero}");
                }
            }

            if (errors.Any())
            {
                return new CommonImportResult(0, string.Join(";", errors));
            }

            var entities = new List<SigerTrPackingFullQty>();
            foreach (var p in checkitems)
            {
                var regions = accDbContext.siger_tr_dict.FirstOrDefault(t => t.status == (int)RowState.Valid
                    && t.cat == AccDictCost.region && t.dval == p.region && t.projectId == projectid);
                var products = accDbContext.siger_project_product.FirstOrDefault(t => t.code == p.productid && t.status == (int)RowState.Valid && t.projectid == projectid);
                if (regions != null)
                {
                    var psEntity = new SigerTrPackingFullQty
                    {
                        projectId = projectid,
                        ProductID = products.code ?? "",
                        PN = p.pn ?? "",
                        Region = regions.dkey ?? "",
                        QTY = p.qty.ToInt(),
                        UID = userid.ToString(),
                        TransDateTime = DateTime.Now
                    };
                    entities.Add(psEntity);
                }
            }
            try
            {
                accDbContext.siger_tr_packing_fullqty.AddRange(entities);
                accDbContext.SaveChanges();
                return new CommonImportResult(1, "1");
            }
            catch
            {
                throw;
            }
        }
    }
}
