﻿using Siger.Middlelayer.CncRepository.Entities;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.CncRepository.Request;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Share.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Siger.Middlelayer.CncRepository.Repositories
{
    internal class ProductionTimeAllocationRepository: CncRepositoryBase<siger_project_production_time_allocation>, IProductionTimeAllocationRepository
    {
        private readonly ApiCncDbContext _context;
        public ProductionTimeAllocationRepository(ApiCncDbContext context) : base(context)
        {
            _context = context;
        }

        public IEnumerable<MachineRestInfo> GetRestTimesByMachine(IEnumerable<int> machineIds, int projectId)
        {
            var result = new List<MachineRestInfo>();
            foreach (var machineId in machineIds)
            {
                var times = _context.siger_project_production_time_allocation.Where(m =>
                    m.machineid == machineId && m.status == (int)RowState.Valid && m.projectid == projectId).ToList();
                foreach (var time in times)
                {
                    var types = time.typeids.Split(',');
                    foreach (var item in types)
                    {
                        var rest = _context.siger_project_rest_type.Where(q => q.id == item.ToInt() && q.status == (int)RowState.Valid && q.projectid == projectId).FirstOrDefault();
                        if (rest!=null)
                        {
                            result.Add(new MachineRestInfo
                            {
                                BingTime = rest.startTime,
                                EndTime = rest.endTime,
                                MachineId = machineId,
                                SectionId = time.sectionid,
                                TimeType = (TimeType)rest.range
                            });
                        }
                       
                    }
                    
                }
            }

            return result;
        }

        public IPagedCollectionResult<RequestSelectTime> GetTypeList(int page, int pagesize, int projectId)
        {
            var list = new List<RequestSelectTime>();
            var guids = _context.siger_project_production_time_allocation.Where(q => q.status == (int)RowState.Valid && q.projectid == projectId).Select(q => q.guid).Distinct();
            foreach (var item in guids)
            {
                var time = _context.siger_project_production_time_allocation.Where(q => q.guid == item && q.status == (int)RowState.Valid && q.projectid == projectId).FirstOrDefault();
                if (time != null)
                {
                    var typeList = time.typeids.Split(',');
                    var type = "";
                    if (typeList.Length > 0)
                    {
                        for (int i = 0; i < typeList.Length; i++)
                        {
                            var rest = _context.siger_project_rest_type.Where(q => q.id == typeList[i].ToInt() && q.status == (int)RowState.Valid && q.projectid == projectId).FirstOrDefault();
                            if (rest != null)
                            {
                                if (type == "")
                                {
                                    type += rest.name;
                                }
                                else
                                {
                                    type += "," + rest.name;
                                }
                            }
                        }
                    }
                    var entity = new RequestSelectTime()
                    {
                        guid = time.guid,
                        add_time = time.add_time,
                        founder = time.founder,
                        remark = time.remark,
                        type = time.type,
                        typeids = type
                    };
                    list.Add(entity);
                }
            }
            var totalCount = list.Count();
            var entities = list.Skip((page - 1) * pagesize)
                                .Take(pagesize)
                                .ToList();
            return new PagedCollectionResult<RequestSelectTime>(entities, totalCount);
        }
    }
}
