﻿using System;
using System.Collections.Generic;

namespace Siger.Middlelayer.CncRepository.Response
{
    public class ResponseGetProductionInfo
    {
        public List<MachineStateProduct> products { get; set; } = new List<MachineStateProduct>();

        public int productid { get; set; } = 0;

        public string productname { get; set; }

        public string productcode { get; set; }

        public string drawno { get; set; }

        public string ordernumber { get; set; }

        public List<string> routes { get; set; } = new List<string>();

        public string username { get; set; }

        /// <summary>
        /// 0 没找到工单 1 找到工单
        /// </summary>
        public int type { get; set; }
    }

    public class MachineStateProduct
    {
        public int productid { get; set; }

        public string productname { get; set; }

        public string productcode { get; set; }

        public string drawno { get; set; }

        public List<string> routes { get; set; } = new List<string>();
    }

    public class ResponseGetMachineState
    {
        public int machineid { get; set; }

        public string location { get; set; }

        public int currentstate { get; set; }

        public string statename { get; set; }

        public double totaltime { get; set; }

        public string username { get; set; }

        public List<MachineOptionState> MachineStates { get; set; } = new List<MachineOptionState>();
    }

    public class MachineOptionState
    {
        public int state { get; set; }

        public string name { get; set; }

        /// <summary>
        /// 是否正常1=>是 0否
        /// </summary>
        public int nomal { get; set; }

        /// <summary>
        /// 1=>未开始 2=>已开始/未结束
        /// </summary>
        public int type { get; set; }
    }

    public class ResponseGetSignOrders
    {
        /// <summary>
        /// 工单号
        /// </summary>
        public string OrderNumber { get; set; }

        /// <summary>
        /// 交期
        /// </summary>
        public string DeliveryTime { get; set; }

        /// <summary>
        /// 产品名称
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// 计划数量
        /// </summary>
        public double PlanCount { get; set; }

        /// <summary>
        /// 完成数量
        /// </summary>
        public double FinishCount { get; set; }

        /// <summary>
        /// 合格率
        /// </summary>
        public double PassRate { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 今日报工
        /// </summary>
        public double ReportCount { get; set; }

        public double NokCount { get; set; }

        public List<MachineReport> MachineReports { get; set; } = new List<MachineReport>();
    }

    public class MachineReport
    {
        public string machine { get; set; }

        public double okcount { get; set; }

        public double nokcount { get; set; }

        public string reporttime { get; set; }
    }
}
