﻿using Siger.Middlelayer.DashboardRepository.Entities;
using Siger.Middlelayer.DashboardRepository.Repositories.Interface;
using Siger.Middlelayer.DashboardRepository.Response;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using System.Linq.Expressions;
using Siger.Middlelayer.Common;

namespace Siger.Middlelayer.DashboardRepository.Repositories
{
    internal class DashboardFactoryChanelRepository : DashboardRepositoryBase<siger_dashboard_factory_chanel>, IDashboardFactoryChanel
    {
        private readonly ApiDashboardDbContext _context;

        public DashboardFactoryChanelRepository(ApiDashboardDbContext context) : base(context)
        {
            _context = context;
        }

        public IEnumerable<ResponseDashboardChanel> GetDashboardChanel(int projectId)
        {
            var query = from c in _context.siger_dashboard_factory_chanel
                        join s in _context.siger_project_level_section on c.section equals s.id
                        where c.projectid == projectId && c.status == (int)RowState.Valid
                        select new ResponseDashboardChanel
                        {
                             id=c.section,
                             title=s.title,
                             pic=c.pic
                        };

            return query.ToList();
        }
    }
}
