﻿using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;
using Microsoft.Extensions.DependencyInjection;
using Siger.Middlelayer.EsopRepository.Repositories;
using Siger.Middlelayer.EsopRepository.Repositories.Interface;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Repositories.Interface;

namespace Siger.Middlelayer.EsopRepository
{
    public class EsopRepositoryFactory
    {
        private static EsopRepositoryFactory _factory;

        public static EsopRepositoryFactory Instance => _factory ?? (_factory = new EsopRepositoryFactory());

        public void Initialization(IServiceCollection services)
        {
            RepositoryFactory.Instance.DiRepositories(services, typeof(IApiConfigRepositoryBase<>));
            DiRepositories(services, typeof(IEsopRepositoryBase<>));
            services.AddDbContext<ApiConfigDbContext>();
            services.AddDbContext<ApiEsopDbContext>();
            services.AddScoped(typeof(IUnitOfWork), typeof(EsopUnitOfWork));
        }

        public void DiRepositories(IServiceCollection services, Type moduleType)
        {
            foreach (Type type in Assembly.Load(GetType().Assembly.GetName()).GetTypes())
            {
                if (typeof(IRepository).IsAssignableFrom(type) && type.IsClass && !type.IsAbstract)
                {
                    var interfaces = type.GetInterfaces();
                    foreach (var i in interfaces)
                    {
                        if (!i.IsGenericType && i != typeof(IRepositoryBase<>)
                                             && i != typeof(IRepository)
                                             && i.Name != moduleType.Name)
                        {
                            services.AddScoped(i, type);
                        }
                    }
                }
            }
        }
    }
}
