﻿using System.Collections.Generic;

namespace Siger.Middlelayer.EsopRepository.Response
{
    public class ResponseGetProcessFlow
    {
        public int process_id { get; set; }

        /// <summary>
        /// 审批人类型：1-指定岗位；2-指定人员
        /// </summary>
        public int approval_usertype { get; set; }

        /// <summary>
        /// 审批人用户组id或者用户id
        /// </summary>
        public string approval_usergroupid { get; set; }

        public string approval_usergroupnames { get; set; }

        /// <summary>
        /// 审批类型 1：会审 2：任意
        /// </summary>
        public int approval_type { get; set; }

        public int step_number { get; set; }
    }

    public class ProcessFlow
    {
        public int process_id { get; set; }

        public int step_number { get; set; }

        public IList<int> approval_userids { get; set; }

        public ProcessFlow()
        {
            approval_userids = new List<int>();
        }
    }

    public class ResponseApprovalHistory
    {
        public string title { get; set; }

        public IList<ApprovalHistory> ApprovalHistories { get; set; }

        public ResponseApprovalHistory()
        {
            ApprovalHistories = new List<ApprovalHistory>();
        }
    }

    public class ApprovalHistory
    {
        public int status { get; set; }

        public string info { get; set; }

        public string audit_time { get; set; }
    }
}
