﻿using System;
using Siger.Middlelayer.Common.FieldEnum;

namespace Siger.Middlelayer.IMSRepository.Entities
{
    /// <summary>
    /// 工单表
    /// </summary>
    public class siger_project_ims_workorder : IMSEntityBase
    {
        /// <summary>
        /// 工单号
        /// </summary>
        public string workorder_code { get; set; }

        /// <summary>
        /// 工艺单id
        /// </summary>
        public int technology_id { get; set; }
        /// <summary>
        /// 刀具号
        /// </summary>
        public string tool_code { get; set; }

        /// <summary>
        /// 需求个数
        /// </summary>
        public int count { get; set; } = 0;

        /// <summary>
        /// 需求时间
        /// </summary>
        public DateTime need_time { get; set; }

        /// <summary>
        /// 操作人
        /// </summary>
        public int operator_id { get; set; } = 0;

        /// <summary>
        /// 工单状态
        /// </summary>
        public OrderStatus order_status { get; set; } = OrderStatus.Untreated;

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime create_time { get; set; }
    }
}
