﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.IMSRepository.Entities;
using Siger.Middlelayer.IMSRepository.Response;

namespace Siger.Middlelayer.IMSRepository.Repositories.Interface
{
    public interface IToolLifeToolChoiceRepository : IIMSRepositoryBase<siger_project_ims_tool_choice>
    {
        IEnumerable<ResponseGetToolChoice> GetPagedChoice(int workorder_id, int techId, int count, 
            int projectId);

        IEnumerable<ResponseGetStockFromWms> GetStockFromWms(IEnumerable<string> partNos, int projectId);

        IEnumerable<ResponseGetStockFromWms> GetStockInfoes(IEnumerable<int> choiceIds, int projectId);

        bool OutStock(IEnumerable<int> choiceIds, int projectId, int userId);

        bool InStock(IEnumerable<siger_project_ims_package> packages, int storage_id, int projectId, int userId);

        IPagedCollectionResult<ResponseGetTechToolList> GetPageList(int techId, int workorder_id, string cutterNumber, int page, int pagesize,
            int toexcel, int projectId);
        bool OutStock(List<siger_project_ims_tool_choice_summary> choices, int projectId, int userId);
    }
}
