﻿using System.Collections.Generic;
using Siger.Middlelayer.Common.FieldEnum;
using Siger.Middlelayer.IMSRepository.Entities;
using Siger.Middlelayer.IMSRepository.Request;
using Siger.Middlelayer.IMSRepository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.IMSRepository.Repositories.Interface
{
    public interface IToolLifeToolRepository : IIMSRepositoryBase<siger_project_ims_tool>
    {
        bool AddToolInfo(RequestAddToolInfo request, int projectId);

        IEnumerable<ToolItemInfo> GetToolList(IEnumerable<int> categoryIds, ImsSettingCategory type,
            int projectid);

        CommonImportResult ImportToolInfos(IEnumerable<IMSInfoList> infos, int projectid, int userId, ImsSettingCategory categoryType);

        IEnumerable<siger_project_ims_tool> GetToolInfos(IEnumerable<int> categoryIds, string name, ImsSettingCategory type, int projectid);
        IEnumerable<ResponseGetMaterials> GetMaterialListEx(int id, string part_no, string name, int count, int projectid);
    }
}
