﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.IMSRepository.Entities;
using Siger.Middlelayer.IMSRepository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.IMSRepository.Repositories.Interface
{
    public interface IToolLifeToolTechRepository : IIMSRepositoryBase<siger_project_ims_tech_tool>
    {
        IPagedCollectionResult<ResponseGetTechToolList> GetPagedList(int techId, string cutterNumber, int page, int pagesize,
            int toexcel, int projectId, int machine_type = 0, string tool_code = "");

        CommonImportResult ImportTechnology(IEnumerable<TechMouldList> techs, int projectid, int userId);

        IEnumerable<ResponseGetTechToolList> GetDataList(int techId, string cutterNumber, int projectId);

        IEnumerable<ResponseGetToolCategory> GetToolCategories(int techId, int projectId);
    }
}
