﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.IMSRepository.Entities;
using Siger.Middlelayer.IMSRepository.Request;
using Siger.Middlelayer.IMSRepository.Response;

namespace Siger.Middlelayer.IMSRepository.Repositories.Interface
{
    public interface IToollifeCabinetReceiveRepository : IIMSRepositoryBase<SigerProjectIMSCabinetReceive>
    {
        IPagedCollectionResult<ResponeCabinetReceiveData> GetCabinetReceiveData(RequestCabinetReceiveData request,
            int pid);

        int InertCabinetReceiveData(SigerProjectIMSCabinetReceive data);

        int UpdateCabinetReceiveData(SigerProjectIMSCabinetReceive data);
        int DeleteCabinetReceiveData(int id);

        IEnumerable<ResponeCabinetReceiveData> GetCabinetReceiveDetailData(DateTime Begin, DateTime End, IEnumerable<int> userIds, int pid);
    }
}
