﻿using System;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.QmsRepository.Repositories
{
    internal class StandardPartsSnRepository : QMSRepositoryBase<siger_qms_standard_parts_sn>, IStandardPartsSnRepository
    {
        private readonly ApiQmsDbContext _context;
        public StandardPartsSnRepository(ApiQmsDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseStandardPartsSn> GetPagedList(int productid, int materialid, string sn, int page, int pagesize, int projectid, int toexcel)
        {
            var query = _context.siger_qms_standard_parts_sn.Where(t => t.projectid == projectid && t.status == (int)RowState.Valid);
            var querylist = from q in query
                            join p in _context.siger_project_product on q.productid equals p.id
                            join m in _context.siger_tr_materials on q.materialid equals m.id
                            join u in _context.siger_user on q.update_mid equals u.id
                            select new ResponseStandardPartsSn
                            {
                                id = q.id,
                                productid = q.productid,
                                productcode = p.code ?? "",
                                productname = p.name ?? "",
                                materialid = q.materialid,
                                materialpn = m.pn ?? "",
                                materialname = m.name ?? "",
                                materialspec = m.spec ?? "",
                                sn = q.sn,
                                updator = u.nickname ?? "",
                                updatetime = q.update_time.ToString(ParameterConstant.DateTimeFormat),
                            };
            Expression<Func<ResponseStandardPartsSn, bool>> productExpression = q => true;
            if (productid > 0)
            {
                productExpression = q => q.productid == productid;
            }
            Expression<Func<ResponseStandardPartsSn, bool>> materialExpression = q => true;
            if (materialid > 0)
            {
                materialExpression = q => q.materialid == materialid;
            }
            Expression<Func<ResponseStandardPartsSn, bool>> snExpression = q => true;
            if (!string.IsNullOrEmpty(sn))
            {
                snExpression = q => q.sn == sn;
            }

            var expression = productExpression.And(materialExpression).And(snExpression);
            var totalCount = querylist.Count(expression);

            if(toexcel == 1)
            {
                return new PagedCollectionResult<ResponseStandardPartsSn>(querylist.Where(expression).ToList(), totalCount);
            }
            else
            {
                var entities = querylist.Where(expression).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
                return new PagedCollectionResult<ResponseStandardPartsSn>(entities, totalCount);
            }
        }
    }
}
