﻿namespace Siger.Middlelayer.Repository.Entities
{
    /// <summary>
    /// 参数表
    /// </summary>
    public class siger_project_parameter : ConfigEntityBase
    {
        /// <summary>
        /// 模块名称，如tpm,cnc
        /// </summary>
        public string module { get; set; }

        /// <summary>
        /// 参数类型，如几何参数
        /// </summary>
        public string category { get; set; }

        /// <summary>
        /// 参数名称，唯一
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 参数值
        /// </summary>
        public string code { get; set; }

        /// <summary>
        /// 单位
        /// </summary>
        public string unit { get; set; } = string.Empty;

        /// <summary>
        /// 参数形式，如：1:文本框 2:下拉框
        /// </summary>
        public int type { get; set; } = 0;

        /// <summary>
        /// 字段类型，预留字段(int,double等等）
        /// </summary>
        public string field_type { get; set; } = string.Empty;

        /// <summary>
        /// 是否必填
        /// </summary>
        public int requried { get; set; } = 0;

        /// <summary>
        /// 最大值，预留
        /// </summary>
        public double max_value { get; set; } = 0;

        /// <summary>
        /// 最小值，预留
        /// </summary>
        public double min_value { get; set; } = 0;

        public int project_id { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string description { get; set; }
    }
}
