﻿using System.Collections.Generic;

namespace Siger.Middlelayer.Repository.Paged
{
    public interface IPagedCollectionResult<T>
    {
        IEnumerable<T> Data { get; }

        int Total { get; }
    }

    public class PagedCollectionResult<T> : IPagedCollectionResult<T>
    {
        public IEnumerable<T> Data { get; private set; }

        public int Total { get; private set; }


        public PagedCollectionResult(IEnumerable<T> entities, long totalCount)
        {
            Data = entities;
            Total = int.Parse(totalCount.ToString());
        }
    }
}
