﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerProjectMachineTypeRepository : IApiConfigRepositoryBase<siger_project_machine_type>
    {
        IPagedCollectionResult<MachineType> GetPagedList(int parentType, int childType, string machineName, int projectid, int page,
            int pagesize);

        IList<int> GetMachineTypeIds(int id, int projectid);

        CommonImportResult ImportMachineTypes(IEnumerable<MachineTypeList> machineTypes, int projectid);

        IEnumerable<MachineType> ExportMachineTypes(int parentType, int childType, string machineName, int projectid);

        IEnumerable<LevelSectionTree> GetLevelMachineTypes(int projectid);

        IEnumerable<MachineTypes> GetMachineTypes(IEnumerable<int> machineIds, int projectId);

        siger_project_machine_type GetMachineType(int typeId);
        IEnumerable<siger_project_machine_type> GetSonMachineTypes(int parentId, int projectid);
    }
}
