﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerTrMaterialTypeRepository : IApiConfigRepositoryBase<siger_tr_material_type>
    {
        IPagedCollectionResult<MaterialType> GetPagedList(int parentType, int projectid, int page,
            int pagesize);

        IList<int> GetMaterialTypeIds(int id, int projectid);

        IEnumerable<MaterialType> GetMaterialTypeList(int projectid);

        CommonImportResult ImportMaterialTypes(IEnumerable<MaterialTypeList> materialTypes, int projectid);

        IEnumerable<MaterialType> ExportMaterialTypes(int parentType, int projectid);

        IEnumerable<MaterialTypeTree> GetMaterialTypeTree(int projectid);

        int InsertMaterialType(siger_tr_material_type materialType);

        int UpdateMaterialType(siger_tr_material_type materialType);

        int UpdateMaterialTypeRange(IEnumerable<siger_tr_material_type> materialTypes);
    }
}
