﻿using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Repositories.Interface;

namespace Siger.Middlelayer.Repository.Repositories
{
    internal class SigerAppProjectConfigRepository : ApiConfigRepositoryBase<siger_app_project_config>, ISigerAppProjectConfigRepository
    {
        private readonly ApiConfigDbContext _context;
        public SigerAppProjectConfigRepository(ApiConfigDbContext context) : base(context)
        {
            _context = context;
        }

        public siger_app_project_config GetAppProjectConfig(int projectId)
        {
            return _context.siger_app_project_config.FirstOrDefault(q =>
                q.projectId == projectId && q.status == (int) RowState.Valid);
        }
    }
}
