﻿using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.WmsRepository.Entities;

namespace Siger.Middlelayer.TlmRepository
{
    public class ApiTlmDbContext : DbContext
    {
        public ApiTlmDbContext(DbContextOptions<ApiTlmDbContext> options) : base(options)
        {
        }
        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnection", string.Empty);
                if (!string.IsNullOrEmpty(mySqlConnection))
                {
                    optionsBuilder.UseMySql(mySqlConnection);
                }
            }
            else
            {
                var clusterConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnection", string.Empty);
                if (!string.IsNullOrEmpty(clusterConnection))
                {
                    optionsBuilder.UseMySql(clusterConnection);
                }
            }
        }

        public DbSet<siger_project_product> siger_project_product { get; set; }

        public DbSet<siger_project_machine_type> siger_project_machine_type { get; set; }

        public DbSet<siger_project_user> siger_project_user { get; set; }

        public DbSet<siger_project_toollife_category> siger_project_toollife_category { get; set; }

        public DbSet<siger_project_toollife_category_parameter> siger_project_toollife_category_parameter { get; set; }

        public DbSet<siger_project_toollife_technology> siger_project_toollife_technology { get; set; }

        public DbSet<siger_project_toollife_tool> siger_project_toollife_tool { get; set; }

        public DbSet<siger_project_toollife_tool_parameter> siger_project_toollife_tool_parameter { get; set; }

        public DbSet<siger_project_toollife_tool_choice> siger_project_toollife_tool_choice { get; set; }

        public DbSet<siger_project_toollife_tech_tool> siger_project_toollife_tech_tool { get; set; }

        public DbSet<siger_project_toollife_workorder> siger_project_toollife_workorder { get; set; }

        public DbSet<siger_project_toollife_meature> siger_project_toollife_meature { get; set; }

        public DbSet<siger_project_toollife_package> siger_project_toollife_package { get; set; }

        public DbSet<siger_project_toollife_tool_install> siger_project_toollife_tool_install { get; set; }

        public DbSet<siger_project_toollife_storage_platform> siger_project_toollife_storage_platform { get; set; }

        public DbSet<siger_project_toollife_use_record> siger_project_toollife_use_record { get; set; }

        public DbSet<siger_project_toollife_tool_choice_summary> siger_project_toollife_tool_choice_summary { get; set; }

        public DbSet<siger_project_toollife_tool_grind> siger_project_toollife_tool_grind { get; set; }

        public DbSet<siger_project_toollife_tool_scrap> siger_project_toollife_tool_scrap { get; set; }

        public DbSet<siger_project_toollife_tool_replace_return> siger_project_toollife_tool_replace_return { get; set; }
        public DbSet<SigerProjectToollifeCabinetConfig> siger_project_toollife_cabinet_config { get; set; }
        public DbSet<SigerProjectToollifeCabinetReceive> siger_project_toollife_cabinet_receive { get; set; }
        public DbSet<SigerProjectToollifeCabinetReceiveDetail> siger_project_toollife_cabinet_receive_detail { get; set; }

        //wms相关
        public DbSet<siger_wms_stock> siger_wms_stock { get; set; } // 库存表

        public DbSet<siger_wms_storage> siger_wms_storage { get; set; } //仓库表
        public DbSet<siger_wms_storage_location> siger_wms_storage_location { get; set; } //
        public DbSet<siger_wms_storage_type> siger_wms_storage_type { get; set; } //

        public DbSet<SigerTrDict> siger_tr_dict { get; set; } //字典表
        public DbSet<siger_wms_bussinese_contacts> siger_wms_bussinese_contacts { get; set; } //供应商

        public DbSet<siger_tr_materials> siger_tr_materials { get; set; } //物料表

        public DbSet<siger_tr_material_type> siger_tr_material_type { get; set; } //物料类别表

        public DbSet<SigerTrMaterialSupplier> siger_tr_material_supplier { get; set; } //物料供应商关系表

        public DbSet<siger_wms_settings> siger_wms_settings { get; set; }

        public DbSet<siger_wms_id> siger_wms_id { get; set; }

        public DbSet<siger_wms_stock_access_order> siger_wms_stock_access_order { get; set; }

        public DbSet<siger_wms_stock_access_order_detail> siger_wms_stock_access_order_detail { get; set; }

        public DbSet<siger_project_product_route> siger_project_product_route { get; set; }

        public DbSet<siger_wms_stock_detail> siger_wms_stock_detail { get; set; }

        public DbSet<siger_wms_stock_alarm> siger_wms_stock_alarm { get; set; }

        public DbSet<siger_wms_stock_change> siger_wms_stock_change { get; set; }


        public DbSet<siger_project_level_section> siger_project_level_section { get; set; }

        public DbSet<siger_project_machine> siger_project_machine { get; set; }
        public DbSet<ProjectToollifeDetectionEntity> ProjectToollifeDetectionEntities { get; set; }
        public DbSet<ProjectToollifeDetectionDetailEntity> ProjectToollifeDetectionDetailEntities { get; set; }
        public DbSet<ProjectToollifeDetectionRecordEntity> ProjectToollifeDetectionRecordEntities { get; set; }
        public DbSet<ProjectToollifeDetectionReturnEntity> ProjectToollifeDetectionReturnEntity { get; set; }
        public DbSet<ProjectToollifeToolConfigEntity> ProjectToollifeToolConfigEntities { get; set; }
        public DbSet<ProjectToollifeExpectionEntity> ProjectToollifeExpectionEntities { get; set; }
        public DbSet<siger_project_machine_attribution> siger_project_machine_attribution { get; set; }
        public DbSet<ProjectToollifeTestEntity> ProjectToollifeTestEntities { get; set; }

    }
}
