﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.TlmRepository.Repositories.Interface
{
    public interface IToolLifeToolTechRepository : ITlmRepositoryBase<siger_project_toollife_tech_tool>
    {
        IPagedCollectionResult<ResponseGetTechToolList> GetPagedList(int techId, string cutterNumber, int page, int pagesize,
            int toexcel, int projectId, int machine_type = 0, string tool_code = "");

        CommonImportResult ImportTechnology(IEnumerable<TechToolList> techs, int projectid, int userId);

        IEnumerable<ResponseGetTechToolList> GetDataList(int techId, string cutterNumber, int projectId);

        IEnumerable<ResponseGetToolCategory> GetToolCategories(int techId, int projectId);
    }
}
