﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Request;
using Siger.Middlelayer.TlmRepository.Response;

namespace Siger.Middlelayer.TlmRepository.Repositories.Interface
{
    public interface IToollifeCabinetReceiveRepository : ITlmRepositoryBase<SigerProjectToollifeCabinetReceive>
    {
        IPagedCollectionResult<ResponeCabinetReceiveData> GetCabinetReceiveData(RequestCabinetReceiveData request,
            int pid);

        int InertCabinetReceiveData(SigerProjectToollifeCabinetReceive data);

        int UpdateCabinetReceiveData(SigerProjectToollifeCabinetReceive data);
        int DeleteCabinetReceiveData(int id);

        IEnumerable<ResponeCabinetReceiveData> GetCabinetReceiveDetailData(DateTime Begin, DateTime End, IEnumerable<int> userIds, int pid);
    }
}
