//------------------------------------------------------------------------------
//    *****注意*****
//     此代码由工具生成。
//
//     对此文件的更改可能会导致不正确的行为，并且如果
//     重新生成代码，这些更改将会丢失。
//    *****注意*****
//------------------------------------------------------------------------------
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Repositories.Interface;
using Siger.Middlelayer.TlmRepository.Request;
using Siger.Middlelayer.Utility.ImportEntities;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using System.Linq.Expressions;
using Siger.Middlelayer.Repository.Response;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.TlmRepository.Response;
using NPOI.SS.Formula.Functions;

namespace Siger.Middlelayer.TlmRepository.Repositories
{
    public class ProjectToollifeDetectionDetailRepository : RepositoryBase<ProjectToollifeDetectionDetailEntity>, IProjectToollifeDetectionDetailRepository
    {
        private readonly ApiTlmDbContext _context;
        public ProjectToollifeDetectionDetailRepository(ApiTlmDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponeToollifeDetectionDetail> GetPagedList(RequestProjectToollifeDetectionDetail req)
        {
            Expression<Func<ProjectToollifeDetectionDetailEntity, bool>> conditionCommon = q => q.Status == (int)RowState.Valid && q.Projectid == req.ProjectId;

            Expression<Func<ProjectToollifeDetectionDetailEntity, bool>> conditionOrder = q => true;
            if (!string.IsNullOrEmpty(req.OrderNumber))
            {
                conditionOrder = q => q.OrderNumber == req.OrderNumber;
            }
            Expression<Func<ProjectToollifeDetectionDetailEntity, bool>> conditionOrders = q => true;
            if (req.OrderNumbers != null && req.OrderNumbers.Any())
            {
                conditionOrders = q => req.OrderNumbers.Contains(q.OrderNumber);
            }
            var predicates = conditionCommon.And(conditionOrder).And(conditionOrders);
            var totalCount = _context.ProjectToollifeDetectionDetailEntities.Count(predicates);
            List<ProjectToollifeDetectionDetailEntity> entities;
            if (req.Page == 0)
            {
                entities = _context.ProjectToollifeDetectionDetailEntities.Where(predicates).AsNoTracking().ToList();
            }
            else
            {
                entities = _context.ProjectToollifeDetectionDetailEntities.Where(predicates).Skip((req.Page - 1) * req.PageSize).Take(req.PageSize).AsNoTracking().ToList();
            }
            var ret = new List<ResponeToollifeDetectionDetail>();
            foreach (var item in entities)
            {
                var model = Mapper<ProjectToollifeDetectionDetailEntity, ResponeToollifeDetectionDetail>.Map(item);
                var stockData = _context.siger_wms_stock.FirstOrDefault(f => f.id == model.stock_id);
                if (stockData != null)
                {
                    model.location = _context.siger_wms_storage_location.FirstOrDefault(f => f.id == stockData.storage_location_id)?.name ?? "";
                }
                ret.Add(model);
            }
            return new PagedCollectionResult<ResponeToollifeDetectionDetail>(ret, totalCount);

        }

        public CommonImportResult ImportProjectToollifeDetectionDetail(IEnumerable<ProjectToollifeDetectionDetailReportEntity> types, int projectId)
        {
            var errors = new List<string>();
            //todo:导入类型校验
            if (errors.Any())
            {
                return new CommonImportResult(0, string.Join(";", errors));
            }

            //insert
            foreach (var item in types)
            {
                //实体映射
                var enti = Mapper<ProjectToollifeDetectionDetailReportEntity, ProjectToollifeDetectionDetailEntity>.Map(item);
                _context.ProjectToollifeDetectionDetailEntities.Add(enti);
            }
            if (_context.SaveChanges() <= 0)
            {
                return new CommonImportResult(0, CommonEnum.Fail.ToString());
            }
            return new CommonImportResult(1, "1");
        }
    }
}
