using System.Collections;
using System.Collections.Generic;
using Siger.Middlelayer.ToolRepository.Entities;
using Siger.Middlelayer.ToolRepository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.ToolRepository.Repositories.Interface
{
    public interface ISigerProjectToolRepository: IApiToolRepositoryBase<SigerProjectTool>
    {
        List<SigerProjectTool> GetList(int projectID,string toolName,string brand,string supplier,double? priceStart,double? priceEnd,int? toExcel,int page,int pageSize,out int totolCount);

        ResponseDropDownList GetDropDownList(int projectID,string toolName=null,string brand=null);

        /// <summary>
        /// ȡ
        /// </summary>
        /// <returns></returns>
        List<string> GetToolSupplierDropDownList(int projectId);

        CommonImportResult ImportTools(IEnumerable<ToolSupplierList> tools, int projectId);
        IEnumerable getAllUserByCurrentUserProjectId(int projectId);

        IEnumerable<SigerProjectTool> getlistToolByProject(int projectID);
    }
}