﻿using System;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Repositories.Interface;
using Siger.Middlelayer.TpmRepository.Response;

namespace Siger.Middlelayer.TpmRepository.Repositories
{
    internal class ProjectCheckRepository : TpmRepositoryBase<siger_project_check>, IProjectCheckRepository
    {
        private readonly ApiTpmDbContext _context;
        public ProjectCheckRepository(ApiTpmDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseMachineCheck> GetPagedMachineChecks(int machinestatus, int machinetypeid, int sectionid,
            int projectId, int page = 1, int pagesize = 10)
        {
            var querylist = from q in _context.siger_project_check
                where q.projectid == projectId && q.status != (int) RowState.Invalid
                select new ResponseMachineCheck
                {

                };

            Expression<Func<ResponseMachineCheck, bool>> starttimeExpression = q => true;
            

            var predicate = starttimeExpression;

            var totalCount = querylist.Count(predicate);
            var entities = querylist.Where(predicate).OrderByDescending(q => q.create_time).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();

            return new PagedCollectionResult<ResponseMachineCheck>(entities, totalCount);
        }
    }
}
