﻿using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Repository.Data.Tpm;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Repositories.Interface;
using Siger.Middlelayer.TpmRepository.Request;

namespace Siger.Middlelayer.TpmRepository.Repositories
{
    internal class RepairReportRepository : TpmRepositoryBase<siger_project_repair_report>, IRepairReportRepository
    {
        private readonly ApiTpmDbContext _context;
        public RepairReportRepository(ApiTpmDbContext context) : base(context)
        {
            _context = context;
        }

        public IEnumerable<SetLevel> GetSetLevels(int machinelevel, int projectId)
        {
            var query = from q in _context.siger_project_repair_report_level
                join u in _context.siger_project_usergroup on q.usergroup_id equals u.id
                where q.status == (int) RowState.Valid && q.machinelevel == machinelevel && q.project_id == projectId
                select new SetLevel
                {
                    level = q.level,
                    usergroup_id = q.usergroup_id,
                    id = q.id,
                    title = u.title
                };
            return query.AsEnumerable();
        }

        public int SetMessageRepeatTime(string time)
        {
            //修改系统设置
            var config = _context.siger_system_config.FirstOrDefault(q => q.key == SystemConfigKey.MessageRepeatTime && q.status == (int)RowState.Valid);
            if (config == null)
            {
                var entity = new siger_system_config
                {
                    key = SystemConfigKey.MessageRepeatTime,
                    name = "应急维修消息重复推送时间间隔",
                    value = time,
                    type = "int",
                    description = "应急维修消息重复推送时间间隔"
                };
                _context.siger_system_config.Add(entity);
            }
            else if (config.value != time)
            {
                config.value = time;
                _context.siger_system_config.Update(config);
            }

            return _context.SaveChanges();
        }

        public int AddLevels(RequestSetLevel request, int projectId)
        {
            var groups = _context.siger_project_repair_report_level.Where(q => q.level == request.level
                                                                               && q.project_id == projectId
                                                                               && q.machinelevel == request.machinelevel.ToInt());
            foreach (var group in groups.ToList())
            {
                _context.siger_project_repair_report_level.Remove(group);
            }
            _context.SaveChanges();

            foreach (var groupId in request.usergroup)
            {
                var exist = _context.siger_project_repair_report_level.FirstOrDefault(q => q.level == request.level
                                                                                  && q.project_id == projectId && q.usergroup_id == groupId
                                                                                  && q.machinelevel == request.machinelevel.ToInt());
                if (exist == null)
                {
                    var entity = new siger_project_repair_report_level
                    {
                        level = request.level,
                        machinelevel = request.machinelevel.ToInt(),
                        usergroup_id = groupId,
                        project_id = projectId,
                        status = (int)RowState.Valid
                    };
                    _context.siger_project_repair_report_level.Add(entity);
                }
            }

            return _context.SaveChanges();
        }

        public IEnumerable<int> ListLevelUser(int projectId, int level, int machinelevel)
        {
            var query = from l in _context.siger_project_repair_report_level
                        join u in _context.siger_project_user on l.usergroup_id.ToString() equals u.usergroupid
                        where l.project_id == projectId && l.level == level && l.status == (int)RowState.Valid
                        && l.usergroup_id > 0 && l.machinelevel == machinelevel
                        select u;
            var mids = new List<int>();
            if (query.ToList().Any())
            {
                mids = query.ToList().Select(t => t.mid).ToList();
            }
            return mids;
        }
    }
}
