﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.TpmRepository.Request
{
    public class RequestAddPlan
    {
        public int machineid { get; set; }

        public int instruction_cycle { get; set; }

        public int standard_time { get; set; }

        public string first_instruction_time { get; set; }

        public string starttime { get; set; }

        public string endtime { get; set; }

        public int value_type { get; set; }

        public int up_limit { get; set; }

        public int lower_limit { get; set; }

        public int modeType { get; set; }

        public string unit { get; set; }

        public int severity_level { get; set; }

        public string failure_mode { get; set; }

        public string work_instruction_url { get; set; }

        public string work_instruction_name { get; set; }

        public string remark { get; set; }

        public string date_rang { get; set; }

        public string count { get; set; }

        public string content { get; set; }


        public string maintain_tool { get; set; }

        public string maintain_sparepart { get; set; }

        public string hit_item { get; set; }

        public string maintain_method { get; set; }

        public string faulttype { get; set; }
    }

    public class RequestEditPlan
    {
        [Required(ErrorMessage = "PlanIdIsEmpty")]
        public int planid { get; set; }

        public int itemid { get; set; }

        public int machineid { get; set; }

        public string first_instruction_time { get; set; }

        public string starttime { get; set; }

        public string endtime { get; set; } 

        public int modeType { get; set; }

        public string date_rang { get; set; }

        public string count { get; set; }

        public int mode { get; set; } = 0;
        public string typemode { get; set; }

        public List<BaseModel> Base { get; set; }
    }

    public class BaseModel
    {
        public string date_rang { get; set; }

        public string content { get; set; }

        public int value_type { get; set; }

        public string unit { get; set; }

        public string up_limit { get; set; }

        public string lower_limit { get; set; }

        public int severity_level { get; set; }

        public string failure_mode { get; set; }

        public int standard_time { get; set; }

        public string work_instruction_url { get; set; }

        public string work_instruction_name { get; set; }

        public string remark { get; set; }

        public int instruction_cycle { get; set; }

        public string maintain_tool { get; set; }

        public string maintain_sparepart { get; set; }

        public string hit_item { get; set; }

        public string maintain_method { get; set; }
    }
}
