using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.WmsRepository.Entities;
using Siger.Middlelayer.WmsRepository.Repositories.Interface;
using Siger.Middlelayer.WmsRepository.Response;

namespace Siger.Middlelayer.WmsRepository.Repositories
{
   internal class siger_wms_storageRepository: WMSRepositoryBase<siger_wms_storage>,Isiger_wms_storageRepository
    {
       private readonly ApiWmsDbContext dbContext;
        public siger_wms_storageRepository(ApiWmsDbContext context) : base(context)
        {
            dbContext = context;
        }

        public IEnumerable<ResponseStorage> GetWaveHouseList(int pid,string name, int typeid, int page, int pageSize, out int totalCount,bool export=false)
        {
            //ȡвֿ
            List<int> typeids= dbContext.siger_wms_storage_type.Where(f => f.status == (int)RowState.Valid && f.projectid == pid).Select(f => f.id).ToList();

            var data = GetList(f => typeids.Contains(f.typeid) && f.projectid == pid);
           
            if (!string.IsNullOrEmpty(name))
            {
                data = data.Where(f => f.name.Contains(name));
            }
            if (typeid != 0)
            {
                //ʹӼ,ȡӼid
                if(dbContext.siger_wms_storage_type.Any(f => f.status == (int)RowState.Valid && f.projectid == pid&&f.parentid==typeid))
                {
                    typeids = dbContext.siger_wms_storage_type.Where(f => f.status == (int)RowState.Valid && f.projectid == pid&&f.parentid==typeid).Select(f => f.id).ToList();
                    data = data.Where(f => typeids.Contains(f.typeid ));
                }
                else
                {
                    data = data.Where(f => f.typeid == typeid);
                }
            }

            var result = from list in data
                         join type in dbContext.siger_wms_storage_type on list.typeid equals type.id into tmp
                         from r in tmp
                         from manger in tmp
                         join user1 in dbContext.siger_user on list.creator equals user1.id into tmp2
                         from creator in tmp2
                         join user2 in dbContext.siger_user on list.updator equals user2.id into re
                         from users in re
                         select new ResponseStorage
                         {
                             id = list.id,
                             typeid=list.typeid,
                             typename = r.name,
                             name = list.name,
                             serial_number = list.serial_number,
                             address = list.address,
                             manager = list.manager,
                             status = list.status,
                             description = list.description ?? "",
                             phone=list.phone??"",
                             mobile=list.mobile??""
                         };
            totalCount = result.Count();
            if (export)
            {
                return result;
            }
            return result.Skip((page-1)* pageSize).Take(pageSize);
        }
    }
}

