using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Utility.ExcelImport;
using Siger.Middlelayer.Utility.ImportEntities;
using Siger.Middlelayer.WmsRepository.Entities;
using Siger.Middlelayer.WmsRepository.Repositories.Interface;

namespace Siger.Middlelayer.WmsRepository.Repositories
{
    internal class siger_wms_storage_locationRepository : WMSRepositoryBase<siger_wms_storage_location>, Isiger_wms_storage_locationRepository
    {
        private readonly ApiWmsDbContext dbContext;
        public siger_wms_storage_locationRepository(ApiWmsDbContext context) : base(context)
        {
            dbContext = context;
        }

        public string GenInventoryLevel(int material_id, int ProjectId)
        {
            var entity = dbContext.siger_tr_materials.FirstOrDefault(f =>f.id== material_id&& f.status == (int)RowState.Valid && f.projectId == ProjectId);
            if (entity == null)
            {
                throw new BadRequestException(CommonEnum.NoData);
            }
            var result = new StringBuilder();
            int typeid = entity.typeid;
            while (0 != typeid)
            {
                var type = dbContext.siger_tr_material_type.FirstOrDefault(f => f.id == typeid && f.status == (int)RowState.Valid && f.projectId == ProjectId);
                if (type == null)
                {
                    throw new BadRequestException(RequestEnum.ErrorMaterialType);
                }
                result.Insert(0, type.tcode);
                typeid = type.parentid;
            }
            //ߵTOP㼶
            result.Insert(0, CommonConst.MATERIALTYPE_PARENTNAME);

            return result.ToString();
        }

        public string GenNo(int locationid)
        {
            var ids = new List<int>();
            var entity = Get(locationid);
            if (entity == null)
                throw new BadRequestException(CommonEnum.NoData);
            var pid = entity.parentid;
            ids.Add(locationid);
            int i = 1;
            while (pid != 0)
            {
                var tmp = Get(pid);
                if (tmp == null)
                    throw new BadRequestException(CommonEnum.NoData);
                ids.Insert(0, tmp.id);
                pid = tmp.parentid;
                i++;
                if (i >= 4)
                    break;
            }
            var str = "";
            foreach (var item in ids)
            {
                str += item.ToString();
            }
            //str+=new Random().Next(999999).ToString("D6");
            return str;
        }

        public CommonImportResult ImportStorageLocation(IEnumerable<ImportStorageLocation> locations, int projectid,int userid)
        {
            var errors = new List<string>();
            var rowIndex = 1;
            var types = dbContext.siger_wms_storage_location_type.Where(f => f.projectid == projectid && f.status != 0).OrderBy(o => o.id).AsNoTracking().ToList();
            var insertEntity = new List<siger_wms_storage_location>();

            foreach (var location in locations)
            {
                rowIndex++;
                //check levels
                var storageData = dbContext.siger_wms_storage.FirstOrDefault(f => f.projectid == projectid && f.status != 0 && f.name == location.StorageName);
                if (storageData==null)
                {
                    errors.Add($"{rowIndex},{(int)RequestEnum.StorageError}");
                    break;
                }
                var typeData = types.FirstOrDefault(f => f.name == location.LocationType);
                if (typeData == null)
                {
                    errors.Add($"{rowIndex},{(int)RequestEnum.LocationError}");
                    break;
                }
                var name = location.LocationName;
                var parentid = 0;
                if (!string.IsNullOrEmpty(location.ParentLocation))
                {
                    var parentData = dbContext.siger_wms_storage_location.FirstOrDefault(f => f.storageid == storageData.id && f.projectid == projectid && f.status != 0 && f.realname == location.ParentLocation);
                    if (parentData == null)
                    {
                        errors.Add($"{rowIndex},{(int)RequestEnum.LocationPidNotExist}");
                        break;
                    }
                    if (parentData.typeid >= typeData.id)
                    {
                        errors.Add($"{rowIndex},{(int)RequestEnum.LocationPidCanNotBySelf}");
                        break;
                    }
                    name = parentData.name + "->" + location.LocationName;
                    parentid = parentData.id;
                }
                var model = dbContext.siger_wms_storage_location.FirstOrDefault(f => f.storageid == storageData.id && f.projectid == projectid && f.status != 0 && f.realname == location.LocationName);
                if (model!=null)
                {
                    errors.Add($"{rowIndex},{(int)CommonEnum.RecordExits}");
                    break;
                }
                if (insertEntity.Any(f => f.storageid == storageData.id && f.realname == location.LocationName))
                {
                    errors.Add($"{rowIndex},{(int)CommonEnum.RecordExits}");
                    break;
                }
                insertEntity.Add(new siger_wms_storage_location
                {
                    create_time = DateTime.Now,
                    creator = userid,
                    level = 0,
                    realname = location.LocationName,
                    name = name,
                    option = "",
                    parentid = parentid,
                    projectid = projectid,
                    storageid = storageData.id,
                    updator = userid,
                    update_time = DateTime.Now,
                    typeid = typeData.id,
                    serial_number = GenSerialNumber(),
                    status=1,
                });
            }
            if (errors.Any())
            {
                return new CommonImportResult(0, string.Join(";", errors));
            }
            dbContext.siger_wms_storage_location.AddRange(insertEntity);
            dbContext.SaveChanges();
            return new CommonImportResult(1, "1");
        }

        public string GenSerialNumber()
        {
            return $"{GenKey()}{UnixTimeHelper.GetNow()}";
        }
        private string GenKey()
        {
            char value1 = (char)((new Random().Next() % 26) + 'A');
            char value2 = (char)((new Random().Next() % 26) + 'A');
            return $"{value1}{value2}";
        }
    }
}

