﻿using System;
using System.Data;
using MySql.Data.MySqlClient;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.Redis;

namespace Siger.Middlelayer.Dapper
{
    public abstract class DapperRepositoryBase : IDisposable
    {
        public const string CncProductionTb = "CNC_Production";
        public const string CncExceptionParamsSate = "CNC_ExceptionParamsSate";//生产参数异常报警
        public const string CncAlarmAnalysresult = "CNC_AlarmAnalysresult"; //设备异常报警
        public const string CncSliceSate = "CNC_SliceSate"; //设备切片
        public const string KmTrendTransferTb = "KM_TrendTransfer";
        public const string KM_LocationAlarmTb = "KM_LocationAlarm";//报警记录
        public const string KM_AlarmRecordData = "KM_AlarmRecordData";//报警失效图记录
        public const string CncDailySliceSate = "CNC_DailySliceSate"; //设备日切片
        public const string KM_LabelCounter = "KM_LabelCounter"; //样本数量表
        public const string TMS_SlicePeriod = "TMS_SlicePeriod";
        public const string TMS_ProgramList = "TMS_ProgramList"; //程序号表

        public const string LocationYieldTb = "siger_location_yield"; //产量表
        public const string LocationAlarmTb = "siger_location_alarm"; //设备日切片

        private static string _dbConnection;
        private readonly int _companyId;
        private readonly int _projectId;
        protected DapperRepositoryBase(int companyId, int projectId)
        {
            var useOneDb = ConfigManager.GetValue("DbSetting", "UseOneDb", true);
            if (useOneDb)
            {
                _dbConnection = ConfigManager.GetValue("DbSetting", "DbConnectionKM", string.Empty);
            }
            else
            {
                _dbConnection = ConfigManager.GetValue("DbClusterSetting", "ClusterConnectionKM", string.Empty);
            }
            if (string.IsNullOrEmpty(_dbConnection))
            {
                throw new Exception("DbSetting about [ConnectionKM] not found.");
            }

            _companyId = companyId;
            _projectId = projectId;
        }

        public IDbConnection GetDbConnection()
        {
            try
            {
                var dbConfig = RedisCache.Instance.GetDbName(_companyId, _projectId);

                var connecctionStr = $"{_dbConnection};database={dbConfig.MysqlDbName}";

                var connect = new MySqlConnection(connecctionStr);
                connect.Open();
                return connect;
            }
            catch (Exception e)
            {
                throw new Exception($"connect mysql db {_companyId}_{_projectId} failed, error:" + e);
            }
        }

        public IDbConnection GetBaseDbConnection()
        {
            try
            {
                var mySqlConnection = ConfigManager.GetValue("DbSetting", "DbConnectionKM", string.Empty);
                var connect = new MySqlConnection(mySqlConnection);
                connect.Open();
                return connect;
            }
            catch (Exception e)
            {
                throw new Exception($"connect mysql BaseDb failed, error:" + e);
            }
        }

        public abstract void Dispose();
    }
}
