﻿using Siger.Middlelayer.Common.Configuration;
using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Log;

namespace Siger.Middlelayer.Dapper.FlowMetek
{
    public abstract class RepositoryBase : IDisposable
    {
        /// <summary>
        /// ERP数据源 连接
        /// </summary>
        private static string _dbConnection;
        /// <summary>
        /// 检验数据源连接
        /// </summary>
        private static string _dbConnection2;
        protected RepositoryBase()
        {
            try
            {
                _dbConnection = ConfigManager.GetValue("FlowMetekSqlConnection", "FlowMetekSqlConnection", string.Empty);
                if (string.IsNullOrEmpty(_dbConnection))
                {
                    throw new Exception("DbSetting about [FlowMetekSqlConnection] not found.");
                }
                _dbConnection2 = ConfigManager.GetValue("FlowMetekSqlConnection2", "FlowMetekSqlConnection2", string.Empty);
                if (string.IsNullOrEmpty(_dbConnection2))
                {
                    throw new Exception("DbSetting about [FlowMetekSqlConnection2] not found.");
                }
            }catch(Exception e)
            {
                Logger.WriteLineError(e.ToString());
            }
        }

        public IDbConnection GetDbConnection()
        {
            try
            {
                var connect = new SqlConnection(_dbConnection);
                connect.Open();
                return connect;
            }
            catch (Exception e)
            {
                throw new Exception("FlowMetekSqlConnection1 connect to Open Metek sqlserver failed, error:" + e);
            }
        }
        public IDbConnection GetDbConnection2()
        {
            try
            {
                var connect = new SqlConnection(_dbConnection2);
                connect.Open();
                return connect;
            }
            catch (Exception e)
            {
                throw new Exception("FlowMetekSqlConnection2 connect to Open Metek sqlserver failed, error:" + e);
            }
        }
        public int GetConfigPid()
        {
            var pid = ConfigManager.GetValue("FlowMetekSqlConnection", "ProjectId", string.Empty);
            if (string.IsNullOrEmpty(pid))
            {
                throw new Exception("DbSetting about [ProjectId] not found.");
            }
            return pid.ToInt();
        }
        public string ExcelPath()
        {
            var path = ConfigManager.GetValue("FlowMetekSqlConnection", "ExcelPath", string.Empty);
            if (string.IsNullOrEmpty(path))
            {
                throw new Exception("DbSetting about [ExcelPath] not found.");
            }
            return path;
        }
        public abstract void Dispose();
    }
}
