﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Siger.Middlelayer.Dapper.ResultData;
using Siger.Middlelayer.Share.Models;

namespace Siger.Middlelayer.Dapper.Utilities.Slice
{
    public class DaySliceManager
    {
        public static MachineCanvasDataInfo GetMachineSlice(DateTime dtStart, DateTime dtEnd,
          IEnumerable<CncDailySliceSate> sliceSates, string dateTime, int returnCategory = 1)
        {
            var response = new MachineCanvasDataInfo();
            double shutdown = 100; //关机
            double running = 0; //运行
            double debugging = 0; //调试
            double free = 0; //空闲
            double fault = 0; //故障
            double changeDebugging = 0; // 换线调试
            if (sliceSates == null || !sliceSates.Any())
            {
                response.data = new MachineSateCount
                {
                    datetime = dateTime,
                    num1 = shutdown,
                    num2 = running,
                    num3 = debugging,
                    num4 = free,
                    num5 = fault,
                    num6 = changeDebugging,
                };
                response.datetime = dateTime;
                return response;
            }

            foreach (var dailySliceSate in sliceSates.ToList())
            {
                shutdown += dailySliceSate.shutdown;
                running += dailySliceSate.run;
                debugging += dailySliceSate.debug;
                free += dailySliceSate.free;
                fault += dailySliceSate.fault;
                changeDebugging += dailySliceSate.changeline;
            }

            var total = shutdown + running + debugging + free + fault;
            if (returnCategory == 1) //返回百分比
            {
                response.data = new MachineSateCount
                {
                    datetime = dateTime,
                    num1 = total <= 0 ? 100 : Math.Round(shutdown / total * 100, 2),
                    num2 = total <= 0 ? 0 : Math.Round(running / total * 100, 2),
                    num3 = total <= 0 ? 0 : Math.Round(debugging / total * 100, 2),
                    num4 = total <= 0 ? 0 : Math.Round(free / total * 100, 2),
                    num5 = total <= 0 ? 0 : Math.Round(fault / total * 100, 2),
                    num6 = total <= 0 ? 0 : Math.Round(changeDebugging / total * 100, 2),
                };
            }
            else if (returnCategory == 2) //返回 小时+百分比
            {
                response.data = new MachineSateCount
                {
                    datetime = dateTime,
                    num1 = total <= 0 ? 100 : Math.Round(shutdown / total * 100, 2),
                    num2 = total <= 0 ? 0 : Math.Round(running / total * 100, 2),
                    num3 = total <= 0 ? 0 : Math.Round(debugging / total * 100, 2),
                    num4 = total <= 0 ? 0 : Math.Round(free / total * 100, 2),
                    num5 = total <= 0 ? 0 : Math.Round(fault / total * 100, 2),
                    num6 = total <= 0 ? 0 : Math.Round(changeDebugging / total * 100, 2),
                    hour1 = total <= 0 ? 0 : Math.Round(shutdown / 3600, 2),
                    hour2 = total <= 0 ? 0 : Math.Round(running / 3600, 2),
                    hour3 = total <= 0 ? 0 : Math.Round(debugging / 3600, 2),
                    hour4 = total <= 0 ? 0 : Math.Round(free / 3600, 2),
                    hour5 = total <= 0 ? 0 : Math.Round(fault / 3600, 2),
                    hour6 = total <= 0 ? 0 : Math.Round(changeDebugging / 3600, 2),
                };
            }
            response.datetime = dateTime;
            return response;
        }
    }
}
