﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.RedisEntities;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class CNCEquipmentStateRepository : RedisRepositoryBase
    {
        private readonly bool _dispose;
        public CNCEquipmentStateRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }

        public void Dispose()
        {
            Client?.Dispose();
        }

        /// <summary>
        /// 获取当前设备运行信息
        /// </summary>
        /// <param name="machindId"></param>
        /// <returns></returns>
        public CNCEquipmentState GetCNCEquipmentState(int machindId)
        {
            try
            {
                var data = Client.HGet(HashMachineInfo, machindId.ToString());
                if (!string.IsNullOrEmpty(data))
                {
                    return JsonHelper.DeserializerJsonResult<CNCEquipmentState>(data);
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
            return null;
        }
        public int BlxStnCache(int MachineID)
        {
            try
            {
                var stn = 0;
                var data = Client.HGetAll(HashBlxStnCache);
                if (data.Count != 0)
                {
                    foreach (var v in data)
                    {
                        if (v.Key.StartsWith(MachineID.ToString()+"_"))
                        {
                            if (!string.IsNullOrEmpty(v.Value))
                            {
                                var arry = v.Value.ToString().Replace("[","").Replace("]","").Split(',');
                                if (arry.Length>1)
                                {
                                    int.TryParse(arry[1], out stn);
                                    return stn;
                                }
                            }
                        }
                    }
                }
                return stn;
            }
            catch(Exception e)
            {
                throw e;
            }
       
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="MachineID"></param>
        /// <returns></returns>
        public string BlxCCTime(int MachineID)
        {
            try
            {
                var data = Client.HGet(HashBlxCCTime, MachineID.ToString());
                if (!string.IsNullOrEmpty(data))
                {
                    return data;
                }
                return string.Empty;
            }
            catch (Exception e)
            {
                throw e;
            }
        }
        public int BlxTimeCache(int MachineID)
        {
            try
            {
                var stn = 0;
                var data = Client.HGetAll(HashBlxStnCache);
                if (data.Count != 0)
                {
                    foreach (var v in data)
                    {
                        //if (v.Key.StartsWith(MachineID.ToString() + "_"))
                        //{
                        //    if (!string.IsNullOrEmpty(v.Value))
                        //    {
                        //            int.TryParse(v.Value, out stn);
                        //            return stn;
                        //    }
                        //}
                        if (v.Key.Contains(MachineID.ToString()))
                        {
                            int.TryParse(v.Value, out stn);
                            return stn;
                        }
                    }
                }
                return stn;
            }
            catch (Exception e)
            {
                throw e;
            }
        }
        /// <summary>
        /// 获取当前设备运行信息列表
        /// </summary>
        /// <param name="machindIds"></param>
        /// <returns></returns>
        public List<CNCEquipmentState> GetCNCEquipmentStates(IEnumerable<int> machindIds)
        {
            var result = new List<CNCEquipmentState>();
            try
            {
                foreach (var mc in machindIds)
                {
                    var data = Client.HGet(HashMachineInfo, mc.ToString());
                    if (!string.IsNullOrEmpty(data))
                    {
                        var obj = JsonHelper.DeserializerJsonResult<CNCEquipmentState>(data);
                        result.Add(obj);
                    }
                }

            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
            return result;
        }

        public List<CNCEquipmentState> GetCNCEquipmentStates()
        {
            var result = new List<CNCEquipmentState>();
            try
            {
                var data = Client.HGetAll(HashMachineInfo);
                if (data != null && data.Count > 0)
                {
                    foreach (var v in data)
                    {
                        if (!string.IsNullOrEmpty(v.Value))
                        {
                            result.Add(JsonHelper.DeserializerJsonResult<CNCEquipmentState>(v.Value));
                        }
                    }
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
            return result;
        }

        public void SetLastProcess(int machine,string programLable)
        {
            try
            {
                var filed = $"{machine}";
                Client.HSet(HashToolLastProcessProgram, filed, programLable);
            }catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }
        public string GetLastProcess(int machine)
        {
            try
            {
                var filed = $"{machine}";
                var pn= Client.HGet(HashToolLastProcessProgram, filed);
                return pn;
            }
            catch
            {
                return "";
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }
    }
}
