﻿using System;
using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.Log;
using Siger.Middlelayer.Redis.RedisEntities;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class QMSYieldFixedConfigRepository : RedisRepositoryBase
    {
        private readonly bool _dispose;
        public QMSYieldFixedConfigRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }

        public bool SetConfig(string key, QMSYieldFixedConfig config)
        {
            try
            {
                return Client.HSet(QMSYieldFixedConfig, key, JsonHelper.SerializerToJsonString(config));
            }
            catch(Exception ex)
            {
                throw ex;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public Dictionary<string, QMSYieldFixedConfig> GetConfigs()
        {
            try
            {
                var list = Client.HGetAll<QMSYieldFixedConfig>(QMSYieldFixedConfig);
                if (list.Any())
                {
                    return list;
                }
                return new Dictionary<string, QMSYieldFixedConfig>();
            }
            catch
            {
                return new Dictionary<string, QMSYieldFixedConfig>();
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public void Dispose()
        {
            Client?.Dispose();
        }
    }
}
