﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.RedisEntities;
using Siger.Middlelayer.Redis.Utility;
namespace Siger.Middlelayer.Redis.Repositories
{
    public class ToolMachineCycleUsageRepository : RedisRepositoryBase
    {
        private readonly bool _dispose;
        public ToolMachineCycleUsageRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }

        public void Dispose()
        {
            Client?.Dispose();
        }

        /// <summary>
        /// 获取程序号 使用量
        /// </summary>
        /// <param name="filed"></param>
        /// <returns></returns>
        public ToolMachineCycleUsage GetCycleUsage(int machineId,string pn, string spindleName, string toolName)
        {
            //redis 
            var filed = ConditionHelper.GetCycleUsageFiled(machineId, pn, spindleName, toolName);
            try
            {
                var data = Client.HGet(HashMachineCycleUsage, filed);
                if (!string.IsNullOrEmpty(data))
                {
                    return JsonHelper.DeserializerJsonResult<ToolMachineCycleUsage>(data);
                }
            }
            catch (Exception e)
            {
                throw e;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
            return null;
        }
        /// <summary>
        ///  获取数据分析 预测寿命
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="pn"></param>
        /// <param name="spindleName"></param>
        /// <param name="toolName"></param>
        /// <returns></returns>
        public int GetPredictedToollife(int machineId, string pn, string spindleName, string toolName)
        {
            //redis key
            var filed = ConditionHelper.GetCycleUsageFiled(machineId, pn, spindleName, toolName);
            try
            {
                var data = Client.HGet(HashToolResiduallife, filed);
                if (!string.IsNullOrEmpty(data))
                {
                    return JsonHelper.DeserializerJsonResult<int>(data);
                }
            }
            catch (Exception e)
            {
                throw e;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
            return -1;
        }

        public void ResetToolUsage(int machineId, string pn, string spindleName, string toolName,string changeTime)
        {
            var filed = ConditionHelper.GetCycleUsageFiled(machineId, pn, spindleName, toolName);
            try
            {
                var data = Client.HGet(HashMachineCycleUsage, filed);
                if (!string.IsNullOrEmpty(data))
                {
                    var usage = JsonHelper.DeserializerJsonResult<ToolMachineCycleUsage>(data);
                    if (usage != null)
                    {
                        usage.alarm = 0;
                        usage.usage = 0;
                        usage.changeTime = changeTime;
                    }
                    Client.HSet(HashMachineCycleUsage, filed, JsonHelper.SerializerToJsonString(usage));
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }
        /// <summary>
        /// 数采直接对接写入redis
        /// </summary>
        /// <param name="tools"></param>
        public void SetToolUsage(List<ToolMachineCycleUsage> tools)
        {
            try
            {
                foreach (var tool in tools)
                {
                    var filed = $"{tool.machine}_{tool.pn}_{tool.spindle}_{tool.tool}";
                    Client.HSet(HashMachineCycleUsage, filed, JsonHelper.SerializerToJsonString(tool));
                    SetToolProgram(tool);
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public void SetToolProgram(ToolMachineCycleUsage tool)
        {
            var machine = $"{tool.machine}";
            var data = string.Empty;
            if (!string.IsNullOrEmpty(tool.spn))
            {
                data = $"S{tool.spn}";
            }
            if (!string.IsNullOrEmpty(tool.pn))
            {
                data = $"P{tool.pn}";
            }
            if (!string.IsNullOrEmpty(data))
            {
                Client.HSet(HashToolLastProcessProgram, machine, data);
            }
        }

        public ToolMachineCycleUsage GetToolUsage(int machineId, string spindleName, string toolName)
        {
            try
            {
                var pn = GetToolProgram(machineId);
                if (pn != null && pn.Length > 1)
                {
                    pn = pn.Substring(1, pn.Length - 1);
                }
                else
                {
                    return null;
                }
                var filed = $"{machineId}_{pn}_{spindleName}_{toolName}";
                var ret = Client.HGet(HashMachineCycleUsage, filed);
                return JsonHelper.DeserializerJsonResult<ToolMachineCycleUsage>(ret);
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public string GetToolProgram(int machineId)
        {
            var machine = $"{machineId}";
            
            return Client.HGet(HashToolLastProcessProgram, machine);
        }
    }
}
