﻿using System;

namespace Siger.Middlelayer.Redis.Utility
{
    public class ConditionHelper
    {
        /// <summary>
        /// 拼接Programlist SCORE
        /// Score:mid+datetime 
        /// </summary>
        /// <param name="machineId"></param>
        /// <returns></returns>
        public static long GetProgramlistScore(int machineId,DateTime dateTime)
        {
            return long.Parse($"{machineId}{dateTime:yyyyMMddHHmmssfff}");
        }
        /// <summary>
        /// 拼接ToolsInfo Filed
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="spindleId"></param>
        /// <param name="tool"></param>
        /// <param name="pn"></param>
        /// <param name="spn"></param>
        /// <returns></returns>
        public static string GetToolsInfoFiled(int machineId, int spindleId, int tool, string pn, string spn)
        {
            return $"{machineId}_{spindleId}_{tool}_{pn}_{spn}";
        }
        /// <summary>
        /// ToolsProcessPn Filed
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="spindleId"></param>
        /// <param name="tool"></param>
        /// <param name="processPn"></param>
        /// <returns></returns>
        public static string GetToolsProcessFiled(int machineId, int spindleId, int tool, string processPn)
        {
            return $"{machineId}_{spindleId}_{tool}_{processPn}";
        }
        /// <summary>
        ///  KM_MachineCycleUsage Filed
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="spindleId"></param>
        /// <param name="tool"></param>
        /// <param name="pn"></param>
        /// <returns></returns>
        public static string GetCycleUsageFiled(int machineId, string pn, string spindleName, string toolName)
        {
            return $"{machineId}_{pn}_{spindleName}_{toolName}";
        }
        /// <summary>
        /// TMS_Predicted_Tool_Residual_Life
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="pn"></param>
        /// <param name="spindleName"></param>
        /// <param name="toolName"></param>
        /// <returns></returns>
        public static string GetAnalysiToollifeFiled(int machineId, string pn, string spindleName, string toolName)
        {
            return $"{machineId}_{pn}_{spindleName}_{toolName}";
        }
        public static string GetMornotorKey(int companyId, int projectId, int machineId)
        {
            return $"{companyId}_{projectId}_{machineId}";
        }

        /// <summary>
        /// KM_TrendTransfer field
        /// </summary>
        /// <param name="machineId">设备</param>
        /// <param name="spindle">主轴</param>
        /// <param name="tool">刀位</param>
        /// <param name="pn">加工程序</param>
        /// <returns></returns>
        public static string GetKMtrendTransferFiled(int cid,int pid,int machineId,string spindle,string tool,string program)
        {
            return $"{cid}_{pid}_{machineId}_{program}_{spindle}_{tool}";
        }

        public static string GetRateLifeKey(int machineId, string programno, string spindle, string tool)
        {
           // return $"{machineId}_{programno}_{subprogramno}_{spindle}_{tool}";
            return $"{machineId}_{programno}_{spindle}_{tool}";
        }
        /// <summary>
        /// Calibration filed
        /// </summary>
        /// <param name="machineId">设备ID</param>
        /// <param name="spindleId">主轴</param>
        /// <param name="tool">刀位</param>
        /// <param name="processPn">加工程序号</param>
        /// <returns></returns>
        public static string GetToolCalibrationFiled(int machineId, string spindleId, string tool, string processPn)
        {
            return $"{machineId}_{spindleId}_{tool}_{processPn}";
        }

        /// <summary>
        /// TMS_Reference_Sample filed 
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="spindleId"></param>
        /// <param name="processPn"></param>
        /// <returns></returns>
        public static string GetToolRefrenceNodeFiled(int machineId, string spindleId, string tool, string processPn)
        {
            return $"{machineId}_{spindleId}_{tool}_{processPn}";
        }
    }
}
