// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import App from './App'
import router from './router'
import store from './store'
// import iView from 'view-design'
import ViewUI from 'view-design';
// import $t from 'view-design'
import i18n from '@/locale'
import config from '@/config'
import importDirective from '@/directive'
import {
  directive as clickOutside
} from 'v-click-outside-x'
import installPlugin from '@/plugin'
import './index.less'
import '@/assets/icons/iconfont.css'
import TreeTable from 'tree-table-vue'
import VOrgTree from 'v-org-tree'
import 'v-org-tree/dist/v-org-tree.css'
import md5 from 'js-md5'
import axios from '@/libs/api.request'
import Print from 'vue-print-nb' // 打印插件
import time from './assets/js/time'
import datatype from './assets/js/datatype'
import $ from 'jquery'
import VueAwesomeSwiper from 'vue-awesome-swiper'
// 引入视频播放插件
import VideoPlayer from 'vue-video-player'
import 'vue-video-player/src/custom-theme.css'
import 'video.js/dist/video-js.css'
// 全局挂载
Vue.use(VideoPlayer)

// 引入 jsonp
import {
  VueJsonp
} from 'vue-jsonp'
Vue.use(VueJsonp)

// 引用好看的 Loading
import loading from 'vue-nice-loading'
Vue.use(loading)

// PC端图片预览插件
import 'viewerjs/dist/viewer.css'
import Viewer from 'v-viewer'

Vue.use(Viewer)

// 这里是插件的默认设置
Viewer.setDefaults({
  zIndex: 9999
})

// import style
import 'swiper/css/swiper.css'
// If you use Swiper 6.0.0 or higher
// import 'swiper/swiper-bundle.css'

Vue.use(VueAwesomeSwiper /* { default options with global component } */ )

// 自定义组件
import MoreConbtn from '@/components/moreComponents/moreCon-btn.vue' // 更多按钮组件
import Wangeditor from '@/components/moreComponents/editor-wangeditor.vue' // 富文本编辑器
import largeFileUpload from '@/components/moreComponents/largeFileUpload.vue' // 大文件上传

// import style

// import { initRouter } from '@/libs/router-util' // 新增  引入动态菜单渲染
// 实际打包时应该不引入mock
/* eslint-disable */
// if (process.env.NODE_ENV !== 'production') require('@/mock')
// Vue.use(iView, {
//   i18n: (key, value) => i18n.t(key, value)

// })
Vue.use(ViewUI, {
  i18n: (key, value) => {
    let v = i18n.t(key, value)
    if (v != null && v != undefined) {
      return v
    }
    return ''
  }
})
Vue.use(TreeTable)
Vue.use(VOrgTree)
Vue.use(Print);
Vue.use(time)
Vue.use(datatype)
// Vue.use(ViewUI);

//全局注册 自定义组件
Vue.component("MoreConbtn", MoreConbtn);
Vue.component("editor-wangeditor", Wangeditor);
Vue.component("largeFileUpload", largeFileUpload);

//全局配置 提示
Vue.prototype.$Message.config({
  top: 120,
  duration: 3
});

/**
 * @description 注册admin内置插件
 */
installPlugin(Vue)
/**
 * @description 生产环境关掉提示
 */
Vue.config.productionTip = false
/**
 * @description 全局注册应用配置
 */
Vue.prototype.$config = config
Vue.prototype.$md5 = md5;
Vue.prototype.axios = axios;

/**
 * 注册指令
 */

import Router from 'vue-router'

importDirective(Vue)
Vue.directive('clickOutside', clickOutside)
const originalPush = Router.prototype.push
Router.prototype.push = function push(location) {
  return originalPush.call(this, location).catch(err => err)
}


/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  data: function () { //设置未读消息全局变量
    return {
      UNReadMsgNum: 0,
    }
  },
  i18n,
  store,
  md5,
  render: h => h(App),
  mounted() {
    // initRouter() // 新增 调用方法,动态生成路由,
  }
})

Vue.directive('cell', {
  // bind：只调用一次，指令第一次绑定到元素时调用。在这里可以进行一次性的初始化设置。
  bind: function (el, binding) {},
  // 当被绑定的元素插入到 DOM 中时……
  inserted: function (el, binding) {
    //找到td 元素 添加 更改 合并   rowSpan 或 colSpan
    el.parentNode.parentNode[binding.arg] = binding.value;
  }
})
Vue.directive('rmcell', {
  // bind：只调用一次，指令第一次绑定到元素时调用。在这里可以进行一次性的初始化设置。
  bind: function (el, binding) {},
  // 当被绑定的元素插入到 DOM 中时……
  inserted: function (el, binding) {
    //找到td 元素 移除
    if (binding.arg === 'rowSpan') {
      el.parentNode.parentNode.remove();
    } else {
      let parent = null;
      //合并n列 删除 n-1 次 单元格 的 下一个元素
      for (let i = 0; i < binding.value - 1; i++) {
        el.parentNode.parentNode.nextSibling.remove();
      }
    }
  }
})
