﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.ApiChangLing.Result
{
    public class RequestSparepart
    {
        /// <summary>
        /// 备件编号
        /// </summary>
        public string sparepart_code { get; set; }
        /// <summary>
        /// 备件名称
        /// </summary>
        public string sparepart_name { get; set; }
        /// <summary>
        /// 备件类型
        /// </summary>
        public string sparepart_type { get; set; }
        /// <summary>
        /// 厂商/品牌
        /// </summary>
        public string brand { get; set; }
        /// <summary>
        /// 货值
        /// </summary>
        public string price { get; set; }
        /// <summary>
        /// 库存
        /// </summary>
        public string storage_qty { get; set; }
        /// <summary>
        /// 库存位置
        /// </summary>
        public string storage_location { get; set; }
    }

    #region 备件领用
    public class RequestAdoptSparepart
    {
        /// <summary>
        /// 工单号
        /// </summary>
        public string work_order { get; set; }
        /// <summary>
        /// 设备id
        /// </summary>
        public string machine_id { get; set; }
        /// <summary>
        /// 领用人
        /// </summary>
        public string user_name { get; set; }
        /// <summary>
        /// 领用时间
        /// </summary>
        public string apply_time { get; set; }
        public List<RequestAdoptSparepartDetail> data { get; set; }
    }
    public class RequestAdoptSparepartUpdate
    {
        /// <summary>
        /// 工单号
        /// </summary>
        public string work_order { get; set; }
        /// <summary>
        /// 设备id
        /// </summary>
        public string machine_id { get; set; }
        /// <summary>
        /// 过账凭证
        /// </summary>
        public string voucher { get; set; }
        /// <summary>
        /// 过账状态
        /// </summary>
        public string status { get; set; }
        /// <summary>
        /// 失败原因
        /// </summary>
        public string reason { get; set; }

        public List<RequestAdoptSparepartDetail> data { get; set; }
    }
    public class RequestAdoptSparepartDetail
    {
        /// <summary>
        /// 备件编号
        /// </summary>
        public string sparepart_code { get; set; }

        /// <summary>
        /// 备件名称
        /// </summary>
        public string sparepart_name { get; set; }
        /// <summary>
        /// 领用数量
        /// </summary>
        public string outbound_qty { get; set; }
    }
    #endregion
}
