﻿using FluentScheduler;
using Siger.Middlelayer.AccRepository;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Dapper.FlowMetek;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Share.Constant;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
namespace Siger.ApiFlowMetek.Tasks
{
    /// <summary>
    /// 检验数据 同步到Trace
    /// </summary>
    public class MetekInspectionDTJob : IJob
    {

        private ApiAccDbContext _context;
        private ApiConfigDbContext _cfgContext;
        private InspectionDtRepostiory _InspectionDt;
        public MetekInspectionDTJob()
        {
            _context = new ApiAccDbContext();
            _cfgContext = new ApiConfigDbContext();
            _InspectionDt = new InspectionDtRepostiory();
        }
        public void Execute()
        {
            try
            {
                Logger.WriteLineInfo("MetekInspectionDTJob start...");
                var projectId = _InspectionDt.GetConfigPid();
                if (projectId == 0)
                    return;

                var dic = _context.siger_tr_dict.Where(f => f.projectId == projectId && f.cat == AccDictCost.FlowMetek && f.status == (int)RowState.Valid);
                if (dic == null)
                {
                    Logger.WriteLineInfo("EleStation station id not config");
                    return;
                }
                //电路工站
                var circuit = dic.FirstOrDefault(f => f.dkey == DictKeyValConst.EleCircuitStation);
                if (circuit == null)
                {
                    Logger.WriteLineInfo($"{DictKeyValConst.EleCircuitStation} id not config");
                    return;
                }
                int.TryParse(circuit.dval, out int station);
                //表头工站
                var header = dic.FirstOrDefault(f => f.dkey == DictKeyValConst.EleHeader);
                if (header == null)
                {
                    Logger.WriteLineInfo($"{DictKeyValConst.EleHeader} id not config");
                    return;
                }
                int.TryParse(header.dval, out int statione);
                //皮膜工站
                var staton = dic.FirstOrDefault(f => f.dkey == DictKeyValConst.EleStation);
                if (staton == null)
                {
                    Logger.WriteLineInfo($"EleStation id not config");
                    return;
                }
                int.TryParse(staton.dval, out int stationf);

                var cfg = _cfgContext.siger_project_sync_config.Where(f => f.projectId == projectId && f.module == (int)Module.Acc);
                //电路板
                Circuit(projectId, station, cfg.FirstOrDefault(f => f.table == MeteERPTable.CircuitBoardData));
                //表头电量
                HeadTable(projectId, statione, cfg.FirstOrDefault(f => f.table == MeteERPTable.MeterHeadData));
                //皮膜表
                MetePM(projectId, stationf, cfg.FirstOrDefault(f => f.table == MeteERPTable.InspectionDetial));

            }
            catch (Exception ex)
            {
                Logger.WriteLineInfo(ex.ToString());
            }
        }
        /// <summary>
        /// 电路板检测
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="config"></param>
        void Circuit(int projectId, int station, siger_project_sync_config config)
        {
            try
            {
                string CreateDate = string.Empty;
                if (config != null)
                {
                    CreateDate = config.createDate;
                }
                var data = _InspectionDt.GetMeteCircuits(CreateDate);

                var datetime = DateTime.Now;
                foreach (var item in data)
                {
                    if (item.Createtime != null)
                    {
                        CreateDate = item.Createtime.ToStr();
                    }

                    var trace = _context.siger_tr_sn_trace.FirstOrDefault(f => f.projectId == projectId && f.SN == item.baseNumber&&f.TransDateTime==CreateDate.ToDateTime());
                    if (trace != null)
                    {
                        continue;
                    }
                    var seqID = Guid.NewGuid().ToString();
                    var circuit = new SigerTrSnTrace
                    {

                        SeqID = seqID,
                        LastUpdateTime = datetime,
                        SN = item.baseNumber,
                        Result = item.State.ToStr(),
                        TransDateTime = item.Createtime,
                        UID = item.Operater.ToInt(),
                        projectId = projectId,
                        ProductID = "",
                        Line = 0,
                        Station = station,
                        Position = 0,
                        type = 0

                    };
                    _context.siger_tr_sn_trace.Add(circuit);
                    var data2 = data.Where(f => f.baseNumber == item.baseNumber);

                    foreach (var date in data2)
                    {
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.headNumber,
                            Item = "表头编号"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Waste.ToStr(),
                            Item = "功耗(mA)(0.2-0.4)"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.A1,
                            Item = "低电报警A1信号"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {

                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.A2,
                            Item = "低电报警A2信号"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {

                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Adjust4mA.ToStr(),
                            Item = "4mA调节(mA)(3.96-4.04)"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Adjust20mA.ToStr(),
                            Item = "20mA调节(mA)(19.96-20.04)"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {

                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Temperature.ToStr(),
                            Item = "温度(℃)"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Pressure.ToStr(),
                            Item= "压力(kpa)"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.StdFlow.ToStr(),
                            Item= "瞬时流量"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Velocity100.ToStr(),
                            Item = "100Hz瞬时流速(m³/h)(359.28-360.72)"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.ElectricCurren100.ToStr(),
                            Item = "100Hz电流(mA)(4.496-4.656)"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.IcPulse100,
                            Item = "100Hz Ic脉冲"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.PoPulse100,
                            Item = "100Hz Po脉冲"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Velocity1000.ToStr(),
                            Item = "1000Hz瞬时流速(m³/h)(3592.8-3607.2)"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.ElectricCurren1000.ToStr(),
                            Item = "1000Hz电流(mA)(9.68-9.84)"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.IcPulse1000,
                            Item = "1000Hz Ic脉冲"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.PoPulse1000,
                            Item = "1000Hz Po脉冲"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.tempFiled1.ToStr(),
                            Item = "tempFiled1"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.tempFiled12.ToStr(),
                            Item = "tempFiled12"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.remark,
                            Item = "错误或说明"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.State.ToStr(),
                            Item = "测试结果----状态1合格，0不合格"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Createtime.ToStr(),
                            Item = "检测时间"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Operater,
                            Item = "检测员"
                        });

                    }
                }
                _context.SaveChanges();
                SaveCfg(projectId, config, CreateDate, MeteERPTable.CircuitBoardData);
            }
            catch (Exception ex)
            {
                Logger.WriteLineError(ex.ToString());
            }
        }

        /// <summary>
        /// 表头电量检测
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="config"></param>
        void HeadTable(int projectId, int statione, siger_project_sync_config config)
        {
            try
            {
                string CreateDate = string.Empty;
                if (config != null)
                {
                    CreateDate = config.createDate;
                }
                var data = _InspectionDt.GetHeadTrace(CreateDate);

                var datetime = DateTime.Now;
                foreach (var item in data)
                {
                    if (item.CreateTime != null)
                    {
                        CreateDate = item.CreateTime.ToStr();
                    }
                    var trace = _context.siger_tr_sn_trace.FirstOrDefault(f => f.projectId == projectId && f.SN == item.HeadNumber);
                    if (trace == null)
                    {
                        var seqID = Guid.NewGuid().ToString();
                        var circuit = new SigerTrSnTrace
                        {
                            SeqID = seqID,
                            SN = item.HeadNumber ?? "",
                            Result = item.State.ToStr(),
                            TransDateTime = item.CreateTime,
                            LastUpdateTime = datetime,
                            UID = item.Operater.ToInt(),
                            projectId = projectId,
                            ProductID = "",
                            Line = 0,
                            Station = statione,
                            Position = 0,
                            type = 0

                        };
                        _context.siger_tr_sn_trace.Add(circuit);
                        var data2 = data.Where(f => f.HeadNumber == item.HeadNumber);
                        foreach (var date in data2)
                        {
                            //_context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            //{
                            //    SeqID = seqID,
                            //    SN = item.HeadNumber ?? "",
                            //    projectId = projectId,
                            //    TransDateTime = datetime,
                            //    LastUpdateTime = datetime,
                            //    Value = date.DeviceType.ToStr(),
                            //    Item = "设备类型",
                            //    Result = ""
                            //});
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                Value = date.Flow1Hz.ToStr(),
                                Item = "瞬时流速(m³/h)（1HZ）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                SN = item.HeadNumber ?? "",
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                projectId = projectId,
                                Value = date.Current1Hz.ToStr(),
                                Item = "电流(mA)（1HZ）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Flow100Hz.ToStr(),
                                Item = "瞬时流速(m³/h)（100HZ）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Current100Hz.ToStr(),
                                Item = "电流(mA)（100HZ）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Flow200Hz.ToStr(),
                                Item = "瞬时流速(m³/h)（200HZ）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Current200Hz.ToStr(),
                                Item = "电流(mA)（200HZ）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Flow500Hz.ToStr(),
                                Item = "瞬时流速(m³/h)（500HZ）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Current500Hz.ToStr(),
                                Item = "电流(mA)（500HZ）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Flow1000Hz.ToStr(),
                                Item = "瞬时流速(m³/h)（1000HZ）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Current1000Hz.ToStr(),
                                Item = "电流(mA)（1000HZ）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Flow1000HzTN10.ToStr(),
                                Item = "瞬时流速(m³/h)（1000HZ，-10℃）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Flow1000HzTP40.ToStr(),
                                Item = "瞬时流速(m³/h)（1000HZ，20℃）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Flow1000HzP200.ToStr(),
                                Item = "瞬时流速(m³/h)（1000HZ，200KPa）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Flow1000HzP450.ToStr(),
                                Item = "瞬时流速(m³/h)（1000HZ，450KPa）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.SumIcPulse.ToStr(),
                                Item = "输出Ic脉冲",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.SumTotal.ToStr(),
                                Item = "表头测试总量(m³)",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.SumPoPulse.ToStr(),
                                Item = "Po脉冲",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.TempLine.ToStr(),
                                Item = "温度线性",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.TempZero.ToStr(),
                                Item = "温度零点",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.PressLine.ToStr(),
                                Item = "压力线性",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.PressZero.ToStr(),
                                Item = "压力零点",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Temp24V.ToStr(),
                                Item = "温度（电压24V）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Temp25_2V.ToStr(),
                                Item = "温度（电压25.2V）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Temp22_8V.ToStr(),
                                Item = "温度（电压22.8V）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Press24V.ToStr(),
                                Item = "压力（电压24V）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Press25_2V.ToStr(),
                                Item = "压力（电压25.2V）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Press22_8V.ToStr(),
                                Item = "压力（电压22.8V）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Flow24V.ToStr(),
                                Item = "流速（电压24V）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Flow25_2V.ToStr(),
                                Item = "流速（电压25.2V）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Flow22_8V.ToStr(),
                                Item = "流速（电压22.8V）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.TempValidation921.ToStr(),
                                Item = "温度（电阻921Ω）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.TempValidation1000.ToStr(),
                                Item = "温度（电阻1000Ω）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.TempValidation1077.ToStr(),
                                Item = "温度（电阻1077Ω）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.TempValidation1155.ToStr(),
                                Item = "温度（电阻1155Ω）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.TempValidation1232.ToStr(),
                                Item = "温度（电阻1232Ω）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.PressValidation100.ToStr(),
                                Item = "压力（压强100KPa）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.PressStandard100.ToStr(),
                                Item = "压力标准（压强100KPa）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.PressValidation200.ToStr(),
                                Item = "压力（压强200KPa）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.PressStandard200.ToStr(),
                                Item = "压力标准（压强200KPa）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.PressValidation300.ToStr(),
                                Item = "压力（压强300KPa）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.PressStandard300.ToStr(),
                                Item = "压力标准（压强300KPa）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.PressValidation400.ToStr(),
                                Item = "压力（压强400KPa）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.PressStandard400.ToStr(),
                                Item = "压力标准（压强400KPa）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.PressValidation500.ToStr(),
                                Item = "压力（压强500KPa）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.PressStandard500.ToStr(),
                                Item = "压力标准（压强500KPa）",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Remark,
                                Item = "备注",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.State.ToStr(),
                                Item = "检测结果",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.CreateTime.ToStr(),
                                Item = "时间",
                                Result = ""
                            });
                            _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                            {
                                SeqID = seqID,
                                TransDateTime = datetime,
                                LastUpdateTime = datetime,
                                SN = item.HeadNumber ?? "",
                                projectId = projectId,
                                Value = date.Operater,
                                Item = "检测员",
                                Result = ""
                            });
                        }
                    }
                }
                _context.SaveChanges();
                SaveCfg(projectId, config, CreateDate, MeteERPTable.MeterHeadData);
            }
            catch (Exception ex)
            {
                Logger.WriteLineError(ex.ToString());
            }

        }

        /// <summary>
        /// 皮膜表检测
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="config"></param>
        void MetePM(int projectId, int stationf, siger_project_sync_config config)
        {
            try
            {
                string CreateDate =string.Empty;

                if (config != null)
                {
                    CreateDate = config.createDate;
                }
                var data = _InspectionDt.GetMeteSums(CreateDate);

                var datetime = DateTime.Now;
                foreach (var item in data)
                {
                    if (item.Createtime != null)
                    {
                        CreateDate = item.Createtime.ToStr();
                    }
                    var trace = _context.siger_tr_sn_trace.FirstOrDefault(f => f.projectId == projectId && f.SN == item.baseNumber);
                    if (trace != null)
                    {
                        continue;
                    }
                        var seqID = Guid.NewGuid().ToString();
                        var circuit = new SigerTrSnTrace
                        {
                            SeqID = seqID,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            Result = "OK",
                            TransDateTime = item.Createtime,
                            UID = item.employee.ToInt(),
                            projectId = projectId,
                            ProductID = "",
                            Line = 0,
                            Station = stationf,
                            Position = 0,
                            type = 0

                        };
                        _context.siger_tr_sn_trace.Add(circuit);
                        var data2 = data.Where(f => f.baseNumber == item.baseNumber);
                        foreach (var date in data2)
                        {
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.CommunicateNo ?? "",
                            Item = "表号"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Appearance ?? "",
                            Item = "外观"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Sealability ?? "",
                            Item = "密封性"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Seal ?? "",
                            Item = "封印"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.BreakpointProtection ?? "",
                            Item = "断电保护"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.PulseCheck ?? "",
                            Item = "计脉检查"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.CommFrequency ?? "",
                            Item = "通讯频率"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.CommDistance ?? "",
                            Item = "通讯距离"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.StaticCurrent ?? "",
                            Item = "静态电流"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.MaxCurrent ?? "",
                            Item = "最大电流"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.SupplyVoltage ?? "",
                            Item = "电源电压"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Qmax.ToString() ?? "",
                            Item = "最大误差"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Qmax2.ToString() ?? "",
                            Item = "最大误差"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Qmid.ToString() ?? "",
                            Item = "平均误差"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Qmid2.ToString() ?? "",
                            Item = "平均误差2"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Qmin.ToString() ?? "",
                            Item = "最小误差"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Pressure ?? "",
                            Item = "压力损失"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Judge ?? "",
                            Item = "判定"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Remark ?? "",
                            Item = "备注"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.total ?? "",
                            Item = "总量"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.signal ?? "",
                            Item = "信号强度"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.version ?? "",
                            Item = "版本"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.batch ?? "",
                            Item = "批次"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.employee ?? "",
                            Item = "质检员"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.IMEI ?? "",
                            Item = "IMEI号"
                        });
                        _context.siger_tr_sn_trace_detail.Add(new SigerTrSNTraceDetail
                        {
                            SeqID = seqID,
                            TransDateTime = datetime,
                            LastUpdateTime = datetime,
                            SN = item.baseNumber,
                            projectId = projectId,
                            Value = date.Createtime.ToStr() ??"",
                            Item = "创建时间"
                        });
                        
                    }
                    
                }
                _context.SaveChanges();
                SaveCfg(projectId, config, CreateDate, MeteERPTable.InspectionDetial);
            }
            catch (Exception ex)
            {
                Logger.WriteLineError(ex.ToString());
            }
        }

        void SaveCfg(int projectId, siger_project_sync_config config, string CreateDate, string table)
        {
            if (config != null)
            {
                config.createDate = CreateDate.Trim();
                config.lastupdate = DateTime.Now;
                _cfgContext.siger_project_sync_config.Update(config);
            }
            else
            {
                _cfgContext.siger_project_sync_config.Add(new siger_project_sync_config
                {
                    projectId = projectId,
                    module = (int)Module.Acc,
                    createDate = CreateDate.Trim(),
                    lastupdate = DateTime.Now,

                    status = 1,
                    table = table
                });
            }
            _cfgContext.SaveChanges();
        }
        void SaveIdCfg(int projectId, siger_project_sync_config config, int id, string table)
        {
            if (config != null)
            {
                config.createDate = id.ToString();
                config.lastupdate = DateTime.Now;
                _cfgContext.siger_project_sync_config.Update(config);
            }
            else
            {
                _cfgContext.siger_project_sync_config.Add(new siger_project_sync_config
                {
                    projectId = projectId,
                    module = (int)Module.Acc,
                    createDate = id.ToString(),
                    lastupdate = DateTime.Now,

                    status = 1,
                    table = table
                });
            }
            _cfgContext.SaveChanges();
        }
    }
}

